/*
 * Decompiled with CFR 0.152.
 */
package net.model3.win32.registry;

import com.jniwrapper.win32.registry.RegistryKeyType;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import java.util.HashMap;
import java.util.Map;
import net.model3.collections.CaseInsensitiveMapWrapper;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.Tokenizer;

public class RegistryTypeHandler {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final Map<RegistryKeyType, RegistryTypeHandler> typeHandlers_ = new HashMap<RegistryKeyType, RegistryTypeHandler>();
    private static final Map<String, RegistryTypeHandler> typeHandlersByName_ = new CaseInsensitiveMapWrapper();
    private RegistryKeyType type_;
    private String name_;

    String toString(RegistryKeyValues.RegistryValueEntry registryValueEntry) {
        if (registryValueEntry.getType().equals((Object)this.type_)) {
            return this.toStringImpl(registryValueEntry);
        }
        throw new RuntimeException("not the same types " + registryValueEntry.getType() + "  " + this.type_);
    }

    public String toString() {
        return this.name_;
    }

    Object fromString(String string) {
        throw new RuntimeException("fromString() not implemented for " + this.name_);
    }

    String toStringImpl(RegistryKeyValues.RegistryValueEntry registryValueEntry) {
        throw new RuntimeException("toStringImpl() not implemented for " + this.name_);
    }

    private static void addTypeHandler(String string, RegistryKeyType registryKeyType, RegistryTypeHandler registryTypeHandler) {
        registryTypeHandler.type_ = registryKeyType;
        registryTypeHandler.name_ = string;
        typeHandlers_.put(registryTypeHandler.type_, registryTypeHandler);
        typeHandlersByName_.put(string.toLowerCase(), registryTypeHandler);
    }

    public static RegistryTypeHandler getTypeHandler(RegistryKeyType registryKeyType) {
        return typeHandlers_.get(registryKeyType);
    }

    public static RegistryTypeHandler getTypeHandler(String string) {
        RegistryTypeHandler registryTypeHandler = typeHandlersByName_.get(string.toLowerCase());
        if (registryTypeHandler == null) {
            throw new RuntimeException("unable to find registry type handler=" + string);
        }
        return registryTypeHandler;
    }

    public String getName() {
        return this.name_;
    }

    public boolean resolveEnvironmentVariables() {
        return true;
    }

    public RegistryKeyType getType() {
        return this.type_;
    }

    static {
        RegistryTypeHandler.addTypeHandler("BINARY", RegistryKeyType.BINARY, new RegistryTypeHandler(){

            @Override
            String toStringImpl(RegistryKeyValues.RegistryValueEntry registryValueEntry) {
                StringBuffer stringBuffer = new StringBuffer();
                byte[] byArray = (byte[])registryValueEntry.getValue();
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(StringX.byteToHexString((byte)byArray[i]));
                    stringBuffer.append(", ");
                }
                stringBuffer.delete(stringBuffer.length() - ", ".length(), stringBuffer.length());
                return stringBuffer.toString();
            }

            @Override
            Object fromString(String string) {
                Tokenizer tokenizer = new Tokenizer(string, ",");
                String[] stringArray = tokenizer.getAllTokens();
                byte[] byArray = new byte[stringArray.length];
                int n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    try {
                        switch (string2.trim().length()) {
                            case 1: 
                            case 2: {
                                byArray[n++] = (byte)(Integer.parseInt(string2, 16) & 0xFF);
                            }
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        logger.warn((Object)("error " + exception + " with token " + string2 + " in binary string " + string));
                        logger.trace((Object)"stack trace", (Object)exception);
                    }
                }
                if (byArray.length != n) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[n];
                    System.arraycopy(byArray2, 0, byArray, 0, n);
                }
                return byArray;
            }

            @Override
            public boolean resolveEnvironmentVariables() {
                return false;
            }
        });
        RegistryTypeHandler.addTypeHandler("DWORD", RegistryKeyType.DWORD, new RegistryTypeHandler());
        RegistryTypeHandler.addTypeHandler("DWORD_BIG_ENDIAN", RegistryKeyType.DWORD_BIG_ENDIAN, new RegistryTypeHandler());
        RegistryTypeHandler.addTypeHandler("DWORD_LITTLE_ENDIAN", RegistryKeyType.DWORD_LITTLE_ENDIAN, new RegistryTypeHandler(){

            @Override
            String toStringImpl(RegistryKeyValues.RegistryValueEntry registryValueEntry) {
                return registryValueEntry.getValue().toString();
            }

            @Override
            Object fromString(String string) {
                return new Long(string);
            }
        });
        RegistryTypeHandler registryTypeHandler = new RegistryTypeHandler(){

            @Override
            String toStringImpl(RegistryKeyValues.RegistryValueEntry registryValueEntry) {
                return registryValueEntry.getValue().toString();
            }

            @Override
            Object fromString(String string) {
                return string;
            }

            @Override
            public boolean resolveEnvironmentVariables() {
                return false;
            }
        };
        RegistryTypeHandler.addTypeHandler("EXPAND_SZ", RegistryKeyType.EXPAND_SZ, registryTypeHandler);
        RegistryTypeHandler.addTypeHandler("FULL_RESOURCE_DESCRIPTOR", RegistryKeyType.FULL_RESOURCE_DESCRIPTOR, new RegistryTypeHandler());
        RegistryTypeHandler.addTypeHandler("LINK", RegistryKeyType.LINK, new RegistryTypeHandler());
        RegistryTypeHandler.addTypeHandler("MULTI_SZ", RegistryKeyType.MULTI_SZ, new RegistryTypeHandler());
        RegistryTypeHandler.addTypeHandler("NONE", RegistryKeyType.NONE, new RegistryTypeHandler());
        RegistryTypeHandler.addTypeHandler("RESOURCE_LIST", RegistryKeyType.RESOURCE_LIST, new RegistryTypeHandler());
        RegistryTypeHandler.addTypeHandler("SZ", RegistryKeyType.SZ, new RegistryTypeHandler(){

            @Override
            String toStringImpl(RegistryKeyValues.RegistryValueEntry registryValueEntry) {
                try {
                    return registryValueEntry.getValue().toString();
                }
                catch (Exception exception) {
                    return null;
                }
            }

            @Override
            Object fromString(String string) {
                return string;
            }
        });
    }
}

