/*
 * Decompiled with CFR 0.152.
 */
package net.model3.win32.registry;

import java.io.File;
import java.util.Iterator;
import net.model3.file.FileX;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.win32.registry.RegKey;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RegistryHelper {
    private static final Logger logger = LoggerHelper.getLogger();

    static void showUsage() {
        System.err.println();
        System.err.println(" export fileToExportTo RegistryKeyToExport");
        System.err.println(" import fileToImport");
        System.err.println();
        System.err.println("  example export ");
        System.err.println("reghelper export javasoft.xml HKEY_LOCAL_MACHINE\\Software\\JavaSoft");
        System.err.println();
        System.err.println();
        System.err.println("  example import ");
        System.err.println("reghelper import javasoft.xml");
        System.err.println();
        System.err.println();
    }

    public static void importReg(FileX fileX) {
        try {
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read((File)fileX);
            Element element = document.getRootElement();
            Iterator iterator = element.elementIterator("key");
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                RegKey regKey = new RegKey();
                regKey.absolutePath_ = element2.attributeValue("root");
                boolean bl = Boolean.getBoolean(element2.attributeValue("clear"));
                regKey.fromXML(element2);
                if (bl) {
                    regKey.delete();
                }
                regKey.insert();
                System.out.println("registry import to " + regKey.getAbsolutePath() + " completed");
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public static void exportReg(FileX fileX, String string, boolean bl) {
        try {
            Element element;
            Document document;
            SAXReader sAXReader;
            RegKey regKey = RegKey.getRegKey(string);
            regKey.makePathsRelative();
            if (bl && fileX.exists()) {
                sAXReader = new SAXReader();
                document = sAXReader.read((File)fileX);
                element = document.getRootElement();
            } else {
                document = DocumentHelper.createDocument();
                element = DocumentHelper.createElement((String)"registry");
                element.addAttribute("version", "1.0");
                document.add(element);
            }
            sAXReader = regKey.toXML();
            sAXReader.addAttribute("root", regKey.getAbsolutePath());
            sAXReader.addAttribute("clear", "true");
            element.add((Element)sAXReader);
            fileX.write(document.asXML());
            System.out.println("registry export completed");
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }
}

