/*
 * Decompiled with CFR 0.152.
 */
package net.model3.win32.registry;

import java.util.ArrayList;
import net.model3.collections.CollectionX;
import net.model3.file.FileX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.win32.registry.RegistryHelper;
import org.apache.log4j.BasicConfigurator;

public class RegistryExport {
    public static final String EXTENSION_NAME = ".registry";
    private static final Logger logger = LoggerHelper.getLogger();
    private static boolean append_ = false;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        stringArray = RegistryExport.processArgs(stringArray);
        if (stringArray.length != 2) {
            System.err.println("must pass 2 parms for export");
            RegistryExport.showUsage();
        }
        if (!stringArray[0].toLowerCase().endsWith(EXTENSION_NAME)) {
            stringArray[0] = stringArray[0] + EXTENSION_NAME;
        }
        FileX fileX = new FileX(stringArray[0]);
        String string = stringArray[1];
        RegistryHelper.exportReg(fileX, string, append_);
    }

    static String[] processArgs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equalsIgnoreCase("/append")) {
                append_ = true;
                continue;
            }
            arrayList.add(string);
        }
        return (String[])CollectionX.toArray(arrayList, String.class);
    }

    static void showUsage() {
        System.err.println();
        System.err.println("regexport.exe filename registryKey");
        System.err.println();
        System.err.println("  where filename is the name of the exported registry file to import.");
        System.err.println("  and registry key is the  filename is the name of the exported registry file to import.");
        System.err.println();
        System.exit(10);
    }
}

