/*
 * Decompiled with CFR 0.152.
 */
package net.model3.win32.registry;

import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.RegistryKeyType;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import net.model3.lang.Environment;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.win32.RelativePathHelper;
import net.model3.win32.registry.RegKey;
import net.model3.win32.registry.RegistryTypeHandler;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RegValue {
    private static final Logger logger = LoggerHelper.getLogger();
    RegistryTypeHandler typeHandler_;
    String name_;
    String value_;
    transient RegistryKeyValues.RegistryValueEntry entry_;
    transient RegKey parent_;
    transient RegistryKeyType registryKeyType_;

    public RegValue() {
    }

    RegValue(RegistryKeyValues.RegistryValueEntry registryValueEntry, RegKey regKey) {
        this.entry_ = registryValueEntry;
        this.parent_ = regKey;
        this.registryKeyType_ = registryValueEntry.getType();
        this.typeHandler_ = RegistryTypeHandler.getTypeHandler(registryValueEntry.getType());
        this.name_ = registryValueEntry.getKey().toString();
        this.value_ = this.typeHandler_.toString(registryValueEntry);
    }

    public void delete() {
        RegistryKey registryKey = this.parent_.getRegistryKey();
        registryKey.values().remove((Object)this.name_);
        registryKey.close();
    }

    public RegistryKeyValues.RegistryValueEntry getEntry() {
        if (this.entry_ == null) {
            this.entry_ = (RegistryKeyValues.RegistryValueEntry)this.parent_.getRegistryKey().values().get((Object)this.name_);
        }
        return this.entry_;
    }

    public boolean entryExists() {
        return this.getEntry() == null;
    }

    public void insert() {
        if (this.name_.length() == 0) {
            this.name_.toString();
        }
        this.parent_.setValue(this.name_, this.getValue(), this.typeHandler_);
    }

    public Object getValue() {
        return this.typeHandler_.fromString(this.getValueAsString());
    }

    public void makePathsRelative() {
        if (this.registryKeyType_.equals((Object)RegistryKeyType.SZ)) {
            try {
                String string = RelativePathHelper.getInstance().makeRelative(this.value_);
                if (!string.equals(this.value_)) {
                    this.value_ = string;
                }
            }
            catch (RuntimeException runtimeException) {
                logger.warn((Object)runtimeException.getMessage());
                logger.trace((Object)("error making path relative for " + this), (Object)runtimeException);
            }
        }
    }

    public String getValueAsString() {
        return this.value_;
    }

    public String toString() {
        return this.parent_.getAbsolutePath() + "@" + this.name_ + "=" + this.value_;
    }

    public Element toXML() {
        Element element = DocumentHelper.createElement((String)"value");
        element.addAttribute("name", this.name_);
        element.addAttribute("type", this.typeHandler_.getName());
        element.addAttribute("value", this.value_);
        return element;
    }

    public void fromXML(Element element) {
        this.name_ = element.attributeValue("name");
        this.value_ = element.attributeValue("value");
        this.typeHandler_ = RegistryTypeHandler.getTypeHandler(element.attributeValue("type"));
        if (this.typeHandler_.resolveEnvironmentVariables()) {
            this.value_ = Environment.getInstance().resolve(this.value_, true);
        }
    }

    public String getName() {
        return this.name_;
    }
}

