/*
 * Decompiled with CFR 0.152.
 */
package net.model3.win32.registry;

import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.model3.collections.CollectionX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.win32.registry.RegValue;
import net.model3.win32.registry.RegistryTypeHandler;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RegKey {
    private static final Logger logger = LoggerHelper.getLogger();
    private String name_;
    private RegKey[] subKeys_;
    private RegValue[] values_;
    transient String absolutePath_;
    transient RegKey parent_;
    transient String relativePath_;
    transient RegistryKey registryKey_;

    public RegKey() {
    }

    private RegKey(RegKey regKey, String string) {
        this.parent_ = regKey;
        this.name_ = string;
        this.registryKey_ = regKey.getRegistryKey().openSubKey(this.name_);
        this.absolutePath_ = this.registryKey_.getAbsolutePath();
    }

    RegKey(RegistryKey registryKey) {
        this(registryKey, null, true);
    }

    private RegKey(RegistryKey registryKey, RegKey regKey, boolean bl) {
        this.registryKey_ = registryKey;
        this.name_ = RegKey.getLastPath(registryKey.getName());
        this.absolutePath_ = registryKey.getAbsolutePath();
        this.parent_ = regKey;
        if (bl) {
            this.initSubKeys();
            this.initValues();
        }
    }

    public RegKey createSubKey(String string) {
        RegistryKey registryKey = this.getRegistryKey(true);
        RegistryKey registryKey2 = registryKey.createSubKey(string);
        registryKey.close();
        return new RegKey(registryKey2, this, false);
    }

    private void initSubKeys() {
        int n = 0;
        this.subKeys_ = new RegKey[this.registryKey_.getSubKeyCount()];
        for (RegistryKey registryKey : this.registryKey_.getSubkeys()) {
            this.subKeys_[n++] = new RegKey(registryKey, this, true);
        }
    }

    private void initValues() {
        int n = 0;
        this.values_ = new RegValue[this.registryKey_.values().size()];
        for (RegistryKeyValues.RegistryValueEntry registryValueEntry : this.registryKey_.values().getEntries()) {
            this.values_[n++] = new RegValue(registryValueEntry, this);
        }
    }

    public void insert() {
        RegistryKey registryKey = this.registryKeyExists() ? this.getRegistryKey(true) : this.getParent().createSubKey(this.name_).getRegistryKey();
        this.insert(registryKey);
        registryKey.close();
    }

    public void insert(RegistryKey registryKey) {
        Object object;
        int n;
        if (!registryKey.getAbsolutePath().equals(this.getAbsolutePath())) {
            throw new RuntimeException("absolute paths not equal " + registryKey.getAbsolutePath() + "  " + this.getAbsolutePath());
        }
        for (n = 0; n < this.subKeys_.length; ++n) {
            object = this.subKeys_[n];
            ((RegKey)object).insert();
        }
        for (n = 0; n < this.values_.length; ++n) {
            object = this.values_[n];
            ((RegValue)object).insert();
        }
    }

    public void delete() {
        int n;
        RegistryKey registryKey = this.getRegistryKey(true);
        RegistryKeyValues registryKeyValues = registryKey.values();
        RegistryKeyValues.RegistryValueEntry[] registryValueEntryArray = (RegistryKeyValues.RegistryValueEntry[])CollectionX.toObjectArray((Collection)registryKeyValues.getEntries(), RegistryKeyValues.RegistryValueEntry.class);
        for (n = 0; n < registryValueEntryArray.length; ++n) {
            try {
                registryKeyValues.remove(registryValueEntryArray[n].getKey());
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        registryKey.close();
        for (n = 0; n < this.subKeys_.length; ++n) {
            this.subKeys_[n].delete();
        }
        RegistryKey registryKey2 = this.getParent().getRegistryKey(true);
        registryKey2.deleteSubKey(this.name_);
        registryKey2.close();
        this.registryKey_ = null;
    }

    String getRelativePath() {
        if (this.relativePath_ == null) {
            this.getAbsolutePath();
            int n = this.absolutePath_.indexOf(92) + 1;
            this.relativePath_ = this.absolutePath_.substring(n);
        }
        return this.relativePath_;
    }

    String getAbsolutePath() {
        if (this.absolutePath_ == null) {
            if (this.parent_ == null) {
                throw new RuntimeException("absolute path not set");
            }
            this.absolutePath_ = this.getParent().getAbsolutePath() + "\\" + this.name_;
        }
        return this.absolutePath_;
    }

    RegistryKey getRoot() {
        return RegKey.getRoot(this.getAbsolutePath());
    }

    private static String getLastPath(String string) {
        int n = string.lastIndexOf(92);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private static String getRelativePath(String string) {
        int n = string.indexOf(92) + 1;
        return string.substring(n);
    }

    private static String getRootPath(String string) {
        int n = string.indexOf(92);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    private static RegistryKey getRoot(String string) {
        String string2 = RegKey.getRootPath(string);
        if (string2.equalsIgnoreCase("HKEY_LOCAL_MACHINE")) {
            return RegistryKey.LOCAL_MACHINE;
        }
        if (string2.equalsIgnoreCase("HKEY_CLASSES_ROOT")) {
            return RegistryKey.CLASSES_ROOT;
        }
        if (string2.equalsIgnoreCase("HKEY_USERS")) {
            return RegistryKey.USERS;
        }
        if (string2.equalsIgnoreCase("HKEY_CURRENT_USER")) {
            return RegistryKey.CURRENT_USER;
        }
        throw new RuntimeException("don't know how to handle root " + string2);
    }

    public RegistryKey getRegistryKey() {
        return this.getRegistryKey(false);
    }

    public RegistryKey getRegistryKey(boolean bl) {
        if (!bl && this.registryKey_ != null) {
            return this.registryKey_;
        }
        RegistryKey registryKey = this.getRoot().openSubKey(this.getRelativePath(), bl);
        if (!bl) {
            this.registryKey_ = registryKey;
        }
        return registryKey;
    }

    public RegKey getParent() {
        if (this.parent_ == null) {
            String string = this.getRelativePath();
            String string2 = string.substring(0, string.lastIndexOf(92));
            RegistryKey registryKey = this.getRoot().openSubKey(string2, false);
            this.parent_ = new RegKey(registryKey, null, false);
        }
        return this.parent_;
    }

    boolean registryKeyExists() {
        return this.getParent().getRegistryKey(false).exists(this.name_);
    }

    public static RegKey getRegKey(String string) {
        RegistryKey registryKey = RegKey.getRoot(string);
        if (string.indexOf("\\") < 0) {
            return new RegKey(registryKey, null, false);
        }
        String string2 = RegKey.getRelativePath(string);
        return new RegKey(registryKey.openSubKey(string2));
    }

    public void setValue(String string, Object object, RegistryTypeHandler registryTypeHandler) {
        RegistryKey registryKey = this.getRegistryKey(true);
        RegistryKeyValues registryKeyValues = registryKey.values();
        registryKeyValues.put((Object)string, object, registryTypeHandler.getType());
        registryKey.close();
    }

    public void makePathsRelative() {
        int n;
        for (n = 0; n < this.subKeys_.length; ++n) {
            this.subKeys_[n].makePathsRelative();
        }
        for (n = 0; n < this.values_.length; ++n) {
            this.values_[n].makePathsRelative();
        }
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public Element toXML() {
        int n;
        Element element = DocumentHelper.createElement((String)"key");
        element.addAttribute("name", this.name_);
        for (n = 0; n < this.values_.length; ++n) {
            element.add(this.values_[n].toXML());
        }
        for (n = 0; n < this.subKeys_.length; ++n) {
            element.add(this.subKeys_[n].toXML());
        }
        return element;
    }

    public void fromXML(Element element) {
        Object object;
        this.name_ = element.attributeValue("name");
        List list = element.selectNodes("key");
        this.subKeys_ = new RegKey[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = new RegKey();
            ((RegKey)object).fromXML((Element)iterator.next());
            ((RegKey)object).parent_ = this;
            this.subKeys_[n++] = object;
        }
        object = element.selectNodes("value");
        this.values_ = new RegValue[object.size()];
        n = 0;
        iterator = object.iterator();
        while (iterator.hasNext()) {
            RegValue regValue = new RegValue();
            regValue.fromXML((Element)iterator.next());
            regValue.parent_ = this;
            this.values_[n++] = regValue;
        }
    }

    public boolean exists(String string) {
        return this.getRegistryKey().exists(string);
    }

    public RegKey subKey(String string) {
        return new RegKey(this, string);
    }

    public RegValue getValue(String string) {
        if (this.values_ == null) {
            this.initValues();
        }
        for (RegValue regValue : this.values_) {
            if (!regValue.getName().equalsIgnoreCase(string)) continue;
            return regValue;
        }
        return null;
    }
}

