/*
 * Decompiled with CFR 0.152.
 */
package net.model3.win32;

import com.jniwrapper.win32.registry.RegistryKey;
import java.io.File;
import java.io.InputStream;
import net.model3.bean.ReflectionTool;
import net.model3.collections.PropertiesX;
import net.model3.file.FileX;
import net.model3.lang.Environment;
import net.model3.logging.Level;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.win32.RelativePathHelper;
import net.model3.win32.ShellLink;
import org.apache.log4j.BasicConfigurator;

public class StartMenuHelper {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final String[] SHORTCUT_PROPS = new String[]{"description", "iconIndex", "iconLocation", "target", "arguments", "workingDirectory", "hotkey", "showCommand"};
    private static final boolean[] SHORTCUT_PROPS_IS_PATH = new boolean[]{false, false, true, true, false, true, false, false};
    private static ReflectionTool beanTool_;
    private static Environment env_;
    static Directory repositoryStartMenu_;
    static Directory copywareStartMenu_;
    static Directory repositoryQuicklaunch_;
    static Directory copywareQuicklaunch_;
    static Directory repositorySendTo_;
    static Directory copywareSendTo_;
    private static boolean clearTarget_;
    private static boolean showDebug_;
    private static RelativePathHelper relativePathHelper_;

    static void init() {
        BasicConfigurator.configure();
        if (showDebug_) {
            logger.getRoot().setLevel(Level.TRACE);
        } else {
            logger.getRoot().setLevel(Level.WARN);
        }
        beanTool_ = new ReflectionTool();
        env_ = Environment.getInstance();
        repositoryStartMenu_ = StartMenuHelper.getRepositoryMenuDir("start_menu");
        repositoryQuicklaunch_ = StartMenuHelper.getRepositoryMenuDir("quicklaunch");
        repositorySendTo_ = StartMenuHelper.getRepositoryMenuDir("send_to");
        copywareStartMenu_ = new Directory(StartMenuHelper.getUserSpecialFolder("Start Menu"), "copyware");
        copywareSendTo_ = StartMenuHelper.getUserSpecialFolder("SendTo");
        copywareQuicklaunch_ = new Directory((File)StartMenuHelper.getUserDirectory(), "quicklaunch-copyware");
    }

    static void executeCopyMenu(Directory directory, Directory directory2) throws Exception {
        System.out.println("copying  " + directory.getCanonicalPath() + "  to  " + directory2.getCanonicalPath());
        if (clearTarget_) {
            StartMenuHelper.repoSafeClearDirectory(directory2);
        }
        StartMenuHelper.processCopyDirectory(directory, directory2);
    }

    private static void processCopyDirectory(Directory directory, Directory directory2) throws Exception {
        net.model3.newfile.File file;
        directory2.makeDirectories();
        StartMenuHelper.debug("copying " + directory.getCanonicalPath() + "   to   " + directory2.getCanonicalPath());
        for (net.model3.newfile.File file2 : directory.files()) {
            file = new net.model3.newfile.File(directory2, file2.getName());
            try {
                if (file2.getName().toLowerCase().endsWith("lnk.props")) {
                    StartMenuHelper.debug("   copying " + file2.getName());
                    file = new net.model3.newfile.File(file.getParent(), file.getBaseFilename());
                    StartMenuHelper.createLnkFile(file2, file);
                    continue;
                }
                if (file2.getExtension().equalsIgnoreCase("lnk")) {
                    StartMenuHelper.debug("   copying " + file2.getName());
                    file = new net.model3.newfile.File(file.getParent(), file.getName() + ".props");
                    StartMenuHelper.createLnkPropsFile(file2, file);
                    continue;
                }
                file2.copyFileTo(file);
            }
            catch (Exception exception) {
                StartMenuHelper.warning("procesing " + file2.getCanonicalPath());
                StartMenuHelper.warning(exception.getMessage());
            }
        }
        for (net.model3.newfile.File file2 : directory.subDirectories()) {
            file = new Directory(directory2, file2.getName());
            try {
                if (file2.getCanonicalPath().indexOf(".svn") > 0) continue;
                StartMenuHelper.processCopyDirectory((Directory)file2, (Directory)file);
            }
            catch (Exception exception) {
                StartMenuHelper.warning("procesing " + file2.getCanonicalPath());
                StartMenuHelper.warning(exception.getMessage());
            }
        }
    }

    public static Directory getUserSpecialFolder(String string) {
        RegistryKey registryKey = RegistryKey.CURRENT_USER.openSubKey("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
        Object object = registryKey.values().get((Object)string);
        return new Directory(env_.resolve(object.toString()));
    }

    public static FileX getUserDirectory() {
        return new FileX(env_.get("USERPROFILE"));
    }

    public static Directory getRepositoryMenuDir(String string) {
        String string2 = env_.get("copyware");
        if (string2 == null) {
            throw new RuntimeException("copyware env variable not defined");
        }
        Directory directory = new Directory(string2, "menus");
        if (!directory.exists()) {
            throw new RuntimeException("copyware menu directory not found   " + directory.getCanonicalPath());
        }
        Directory directory2 = directory;
        Directory directory3 = new Directory(directory2, string);
        if (!directory3.exists()) {
            throw new RuntimeException("repository menu " + string + " not found in copyware repository " + directory3.getCanonicalPath());
        }
        return directory3;
    }

    static void repoSafeClearDirectory(Directory directory) {
        if (!directory.exists()) {
            directory.makeDirectories();
        }
        StartMenuHelper.debug("clearing directory " + directory.getCanonicalPath());
        for (net.model3.newfile.File file : directory.files()) {
            file.delete();
        }
        for (net.model3.newfile.File file : directory.subDirectories()) {
            if (file.getName().equalsIgnoreCase(".svn")) continue;
            StartMenuHelper.repoSafeClearDirectory((Directory)file);
        }
    }

    static void warning(String string) {
        System.err.println("warning - " + string);
    }

    static void debug(String string) {
        if (showDebug_) {
            System.out.println("          " + string);
        }
    }

    static void createLnkPropsFile(net.model3.newfile.File file, net.model3.newfile.File file2) throws Exception {
        ShellLink shellLink = new ShellLink(file);
        shellLink.load();
        PropertiesX propertiesX = new PropertiesX();
        for (int i = 0; i < SHORTCUT_PROPS.length; ++i) {
            String string = SHORTCUT_PROPS[i];
            String string2 = beanTool_.getBeanPropertyAsString((Object)shellLink, string);
            if (SHORTCUT_PROPS_IS_PATH[i]) {
                string2 = StartMenuHelper.processPath(shellLink, string, string2);
            }
            propertiesX.put((Object)string, (Object)string2);
        }
        propertiesX.save(file2, " win32 shortcut properties");
    }

    static void createLnkFile(net.model3.newfile.File file, net.model3.newfile.File file2) throws Exception {
        ShellLink shellLink = new ShellLink(file2);
        PropertiesX propertiesX = new PropertiesX();
        propertiesX.load((InputStream)file.createInputStream());
        for (String string : propertiesX.keySet()) {
            String string2 = propertiesX.getProperty(string, "");
            beanTool_.setBeanProperty((Object)shellLink, string, string2);
        }
        shellLink.save();
    }

    static String processPath(ShellLink shellLink, String string, String string2) {
        FileX fileX = new FileX(env_.resolve(string2));
        if (relativePathHelper_ == null) {
            relativePathHelper_ = new RelativePathHelper();
        }
        return relativePathHelper_.makeRelative(string2);
    }

    static {
        clearTarget_ = true;
        showDebug_ = false;
    }
}

