/*
 * Decompiled with CFR 0.152.
 */
package net.model3.win32;

import com.jniwrapper.Int;
import com.jniwrapper.Str;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.automation.OleStr;
import com.jniwrapper.win32.automation.types.VariantBool;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.com.impl.IPersistFileImpl;
import com.jniwrapper.win32.com.types.ClsCtx;
import com.jniwrapper.win32.ole.OleFunctions;
import com.jniwrapper.win32.shell.impl.IShellLinkImpl;
import com.jniwrapper.win32.stg.types.StgMode;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.File;

public class ShellLink {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final StgMode STG_MODE_READ_WRITE = new StgMode(2L);
    private static final StgMode STG_MODE_READ = new StgMode(0L);
    private File file_;
    private String target_;
    private String arguments_;
    private String description_;
    private String iconLocation_;
    private int iconIndex_;
    private String workingDirectory_;
    private int hotkey_;
    private int showCommand_;

    public ShellLink(File file) {
        this.file_ = file;
    }

    public void load() {
        if (!this.file_.exists()) {
            throw new RuntimeException("file " + this.file_.getCanonicalPath() + " not found.");
        }
        IShellLinkImpl iShellLinkImpl = new IShellLinkImpl(ClsCtx.INPROC_SERVER);
        iShellLinkImpl.setAutoDelete(false);
        IPersistFileImpl iPersistFileImpl = new IPersistFileImpl((IUnknown)iShellLinkImpl);
        iPersistFileImpl.setAutoDelete(false);
        OleStr oleStr = new OleStr(this.file_.getCanonicalPath());
        iPersistFileImpl.load(oleStr, STG_MODE_READ);
        Str str = new Str(2048);
        Int intVal = new Int((long)str.getMaxLength());
        UInt32 uInt32 = new UInt32(4L);
        iShellLinkImpl.getPath(str, intVal, null, uInt32);
        this.target_ = str.getValue();
        Int intVal2 = new Int(0L);
        iShellLinkImpl.getIconLocation(str, intVal, intVal2);
        this.iconLocation_ = str.getValue();
        this.iconIndex_ = (int)intVal2.getValue();
        this.description_ = iShellLinkImpl.getDescription(new Int(512L)).getValue();
        this.hotkey_ = (int)iShellLinkImpl.getHotkey().getValue();
        this.arguments_ = iShellLinkImpl.getArguments(new Int(2048L)).getValue();
        this.workingDirectory_ = iShellLinkImpl.getWorkingDirectory(new Int(2048L)).getValue();
        this.showCommand_ = (int)iShellLinkImpl.getShowCmd().getValue();
        iPersistFileImpl.release();
        iShellLinkImpl.release();
    }

    public void save() {
        if (!this.file_.getParent().exists()) {
            throw new RuntimeException("parent directory does not exist for " + this.file_.getCanonicalPath());
        }
        IShellLinkImpl iShellLinkImpl = new IShellLinkImpl(ClsCtx.INPROC_SERVER);
        iShellLinkImpl.setAutoDelete(false);
        IPersistFileImpl iPersistFileImpl = new IPersistFileImpl((IUnknown)iShellLinkImpl);
        iPersistFileImpl.setAutoDelete(false);
        OleStr oleStr = new OleStr(this.file_.getCanonicalPath());
        if (this.file_.exists()) {
            iPersistFileImpl.load(oleStr, STG_MODE_READ_WRITE);
        }
        iShellLinkImpl.setPath(new Str(this.target_));
        iShellLinkImpl.setIconLocation(new Str(this.iconLocation_), new Int((long)this.iconIndex_));
        iShellLinkImpl.setDescription(new Str(this.description_));
        iShellLinkImpl.setArguments(new Str(this.arguments_));
        iShellLinkImpl.setWorkingDirectory(new Str(this.workingDirectory_));
        iShellLinkImpl.setHotkey(new UInt16(this.hotkey_));
        iShellLinkImpl.setShowCmd(new Int((long)this.showCommand_));
        VariantBool variantBool = new VariantBool();
        iPersistFileImpl.save(oleStr, variantBool);
        boolean bl = variantBool.getBooleanValue();
        iPersistFileImpl.release();
        iShellLinkImpl.release();
    }

    public void setFile(File file) {
        this.file_ = file;
    }

    public File getFile() {
        return this.file_;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String string) {
        this.description_ = string;
    }

    public int getIconIndex() {
        return this.iconIndex_;
    }

    public void setIconIndex(int n) {
        this.iconIndex_ = n;
    }

    public String getIconLocation() {
        return this.iconLocation_;
    }

    public void setIconLocation(String string) {
        this.iconLocation_ = string;
    }

    public String getTarget() {
        return this.target_;
    }

    public void setTarget(String string) {
        this.target_ = string;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory_;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory_ = string;
    }

    public static void main(String[] stringArray) {
        ShellLink shellLink = new ShellLink(new File("c:/a/astrolog.lnk"));
        shellLink.load();
        shellLink.setDescription("test");
        shellLink.save();
        shellLink.toString();
        System.exit(1);
    }

    public String getArguments() {
        return this.arguments_;
    }

    public void setArguments(String string) {
        this.arguments_ = string;
    }

    public int getHotkey() {
        return this.hotkey_;
    }

    public void setHotkey(int n) {
        this.hotkey_ = n;
    }

    public int getShowCommand() {
        return this.showCommand_;
    }

    public void setShowCommand(int n) {
        this.showCommand_ = n;
    }

    static {
        OleFunctions.oleInitialize();
    }
}

