/*
 * Decompiled with CFR 0.152.
 */
package net.model3.win32;

import java.util.ArrayList;
import java.util.List;
import net.model3.lang.Environment;
import net.model3.lang.Pair;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;

public class RelativePathHelper {
    private static final Logger logger = LoggerHelper.getLogger();
    private static RelativePathHelper instance_;
    private List<Pair<Directory, String>> prefixes_ = new ArrayList<Pair<Directory, String>>();

    public static RelativePathHelper getInstance() {
        if (instance_ == null) {
            instance_ = new RelativePathHelper();
        }
        return instance_;
    }

    public RelativePathHelper() {
        this.addEnvPath("dev", false);
        this.addEnvPath("installed", false);
        this.addEnvPath("copyware", true);
        this.addEnvPath("code_home", true);
        this.addEnvPath("SystemRoot", true);
        this.addEnvPath("userprofile", true);
        this.addEnvPath("ProgramFiles", true);
    }

    private void addEnvPath(String string, boolean bl) {
        String string2 = Environment.getInstance().get(string);
        if (string2 == null && bl) {
            throw new RuntimeException("required environment variable not found " + string);
        }
        Directory directory = new Directory(string2);
        if (!directory.exists()) {
            new RuntimeException("path for prefix '" + string + "' does not exist " + directory.getCanonicalPath());
        }
        this.prefixes_.add((Pair<Directory, String>)new Pair((Object)directory, (Object)string));
    }

    public String makeRelative(String string) {
        Directory directory = new Directory(string);
        if (!directory.isAbsolute()) {
            return string;
        }
        for (Pair<Directory, String> pair : this.prefixes_) {
            Directory directory2 = (Directory)pair.getLeft();
            String string2 = (String)pair.getRight();
            if (!directory.startsWith(directory2)) continue;
            String string3 = directory.getPathRelativeTo(directory2);
            string = "%" + string2 + "%\\" + string3;
            break;
        }
        if (string.length() > 0 && string.indexOf("%") < 0) {
            throw new RuntimeException("path " + directory.getCanonicalPath() + " has an absolute reference.");
        }
        return string;
    }
}

