/*
 * Decompiled with CFR 0.152.
 */
package net.model3.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.ObjectX;
import net.model3.lang.TimeDuration;

public class DateX
implements Externalizable,
Cloneable,
Comparable<DateX> {
    public static final Meridian AM = Meridian.AM;
    public static final Meridian PM = Meridian.PM;
    public static final Meridian[] MERIDIANS = new Meridian[]{AM, PM};
    private final GregorianCalendar delegate_;

    public DateX() {
        this.delegate_ = new GregorianCalendar();
    }

    public DateX(java.sql.Date date, Time time) {
        this(date.getYear() < 1900 ? date.getYear() + 1900 : date.getYear(), date.getMonth() + 1, date.getDate(), time.getHours(), time.getMinutes(), time.getSeconds());
    }

    public DateX(TimeZone timeZone) {
        this.delegate_ = new GregorianCalendar(timeZone);
    }

    public DateX(long l, TimeZone timeZone) {
        this.delegate_ = new GregorianCalendar();
        this.delegate_.setTime(new Date(l));
        this.delegate_.setTimeZone(timeZone);
    }

    public DateX(DateX dateX, TimeZone timeZone) {
        this.delegate_ = (GregorianCalendar)dateX.delegate_.clone();
        this.delegate_.setTimeZone(timeZone);
    }

    public DateX(long l) {
        this.delegate_ = new GregorianCalendar();
        this.delegate_.setTime(new Date(l));
    }

    public DateX(int n, int n2, int n3) {
        this.delegate_ = new GregorianCalendar(n, n2 - 1, n3);
    }

    public DateX(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, null);
    }

    public DateX(int n, int n2, int n3, int n4, int n5, TimeZone timeZone) {
        this(n, n2, n3, n4, n5, 0, null);
    }

    public DateX(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, null);
    }

    public DateX(int n, int n2, int n3, int n4, int n5, int n6, TimeZone timeZone) {
        this.delegate_ = new GregorianCalendar();
        if (timeZone != null) {
            this.delegate_.setTimeZone(timeZone);
        }
        this.delegate_.set(n, n2 - 1, n3, n4, n5, n6);
        this.delegate_.set(14, 0);
    }

    public DateX(GregorianCalendar gregorianCalendar) {
        this.delegate_ = (GregorianCalendar)gregorianCalendar.clone();
    }

    public DateX(Date date) {
        this.delegate_ = new GregorianCalendar();
        this.delegate_.setTime(date);
    }

    public DateX(String string) {
        this(DateX.parseDate(string));
    }

    public int getYear() {
        return this.delegate_.get(1);
    }

    public int getDecade() {
        return this.getYear() / 10 * 10;
    }

    public int getMonth() {
        return this.delegate_.get(2) + 1;
    }

    public int getDay() {
        return this.delegate_.get(5);
    }

    public int getHour() {
        return this.delegate_.get(11);
    }

    public int getMinute() {
        return this.delegate_.get(12);
    }

    public int getSecond() {
        return this.delegate_.get(13);
    }

    public int getMillisecond() {
        return this.delegate_.get(14);
    }

    public DateX add(TimeDuration timeDuration) {
        return new DateX(this.getTimeInMillis() + timeDuration.inMilliseconds());
    }

    private DateX add(int n, int n2) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.delegate_.clone();
        gregorianCalendar.add(n, n2);
        DateX dateX = new DateX(gregorianCalendar);
        return dateX;
    }

    public DateX addMonths(int n) {
        return this.add(2, n);
    }

    public DateX subtractMonths(int n) {
        return this.addMonths(n * -1);
    }

    public DateX subtractDays(int n) {
        return this.addDays(n * -1);
    }

    public DateX addDays(int n) {
        return this.add(5, n);
    }

    public DateX addHours(int n) {
        return this.add(10, n);
    }

    public DateX addMinutes(int n) {
        return this.add(12, n);
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = DateX.getDateFormatter();
        simpleDateFormat.setTimeZone(this.delegate_.getTimeZone());
        return simpleDateFormat.format(this.asDate());
    }

    public boolean beforeInclusive(DateX dateX) {
        if (this.delegate_.equals(dateX.delegate_)) {
            return true;
        }
        return this.delegate_.before(dateX.delegate_);
    }

    public boolean before(DateX dateX) {
        if (this.delegate_.equals(dateX.delegate_)) {
            return false;
        }
        return this.delegate_.before(dateX.delegate_);
    }

    public boolean after(DateX dateX) {
        if (this.delegate_.equals(dateX.delegate_)) {
            return false;
        }
        return this.delegate_.after(dateX.delegate_);
    }

    public boolean afterInclusive(DateX dateX) {
        if (this.delegate_.equals(dateX.delegate_)) {
            return true;
        }
        return this.delegate_.after(dateX.delegate_);
    }

    public java.sql.Date asSqlDate() {
        return new java.sql.Date(this.getTimeInMillis());
    }

    public Timestamp asSqlTimestamp() {
        return new Timestamp(this.getTimeInMillis());
    }

    public Time asSqlTime() {
        return new Time(this.getTimeInMillis());
    }

    public Date asDate() {
        return this.delegate_.getTime();
    }

    public GregorianCalendar asCalendar() {
        return (GregorianCalendar)this.delegate_.clone();
    }

    public Meridian getMeridian() {
        if (this.getHour() < 12) {
            return AM;
        }
        return PM;
    }

    public int getHourAs12Hour() {
        int n = this.getHour();
        if (n == 0) {
            return 12;
        }
        if (n > 12) {
            return n - 12;
        }
        return n;
    }

    public TimeDuration diff(DateX dateX) {
        return new TimeDuration(this.delegate_.getTimeInMillis() - dateX.delegate_.getTimeInMillis() + "ms");
    }

    public TimeDuration diff() {
        return this.diff(new DateX());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.delegate_.setTimeInMillis(objectInput.readLong());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.delegate_.getTimeInMillis());
    }

    public static SimpleDateFormat getDateFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
    }

    private static Date parseDate(String string) {
        try {
            return DateX.getDateFormatter().parse(string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public long getTimeInMillis() {
        return this.delegate_.getTimeInMillis();
    }

    public TimeZone getTimeZone() {
        return this.delegate_.getTimeZone();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public DateX subtract(TimeDuration timeDuration) {
        return new DateX(this.getTimeInMillis() - timeDuration.inMilliseconds());
    }

    public boolean equals(Object object) {
        if (object instanceof Date) {
            return object.equals(this.asDate());
        }
        if (object instanceof GregorianCalendar) {
            object.equals(this.delegate_);
        }
        if (object instanceof DateX) {
            DateX dateX = (DateX)object;
            return this.delegate_.equals(dateX.delegate_);
        }
        return false;
    }

    public DateX supressTime() {
        return new DateX(this.getYear(), this.getMonth(), this.getDay());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.delegate_ == null ? 0 : this.delegate_.hashCode());
        return n;
    }

    public static DateX asTimeOnly(int n, int n2, int n3) {
        DateX dateX = new DateX();
        return new DateX(dateX.getYear(), dateX.getMonth(), dateX.getDay(), n, n2, n3);
    }

    public static DateX getMostRecent(DateX ... dateXArray) {
        DateX dateX = null;
        for (DateX dateX2 : dateXArray) {
            if (dateX2 == null || dateX != null && !dateX2.after(dateX)) continue;
            dateX = dateX2;
        }
        return dateX;
    }

    @Override
    public int compareTo(DateX dateX) {
        return ObjectX.compareTo((Object)this.getTimeInMillis(), (Object)dateX.getTimeInMillis());
    }

    public static DateX getOldest(DateX ... dateXArray) {
        DateX dateX = null;
        for (DateX dateX2 : dateXArray) {
            if (dateX2 == null || dateX != null && !dateX2.before(dateX)) continue;
            dateX = dateX2;
        }
        return dateX;
    }

    public static enum Meridian {
        AM,
        PM;

    }
}

