/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import java.io.OutputStream;
import java.io.PrintStream;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.templater.AbstractTemplate;
import net.model3.templater.TemplateSource;

class TextTemplate
extends AbstractTemplate {
    private static final Logger logger = LoggerHelper.getLogger();
    private String asText_;
    private TemplateSource templateSource_;

    TextTemplate(TemplateSource templateSource) {
        this.templateSource_ = templateSource;
        this.updateDefinition();
    }

    @Override
    void updateDefinition() {
        if (this.templateSource_.hasBeenModified()) {
            this.asText_ = new String(this.templateSource_.asCharArray());
            this.templateSource_.resetModificationFlag();
        }
    }

    @Override
    public void write(OutputStream outputStream, Object object) {
        try {
            outputStream.write(this.asText_.getBytes());
        }
        catch (Exception exception) {
            logger.error((Object)("error processing template " + this.templateSource_), (Object)exception);
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    @Override
    public void write(PrintStream printStream, Object object) {
        printStream.println(this.asText_);
    }
}

