/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.BrowserProperties;
import net.model3.templater.Template;
import net.model3.templater.TemplateFactory;

public class TemplaterServlet
extends HttpServlet {
    private static final Logger logger = LoggerHelper.getLogger(TemplaterServlet.class);
    private TemplateFactory templateFactory_;
    private Template frameTemplate_;
    private String replaceExtension_;
    private static final String CONTENT_TYPE = "text/html";

    public void init() throws ServletException {
        this.templateFactory_ = TemplateFactory.createServletBasedFactory((Servlet)this);
        String string = this.getInitParameter("frame");
        if (string != null) {
            this.frameTemplate_ = this.templateFactory_.getTemplate(string);
        }
        this.replaceExtension_ = this.getInitParameter("actual-extension");
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.serviceRequest(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.serviceRequest(httpServletRequest, httpServletResponse);
    }

    void serviceRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String string;
            Template template;
            httpServletResponse.setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setHeader("Expires", "0");
            httpServletResponse.setContentType(CONTENT_TYPE);
            String string2 = httpServletRequest.getRequestURI();
            if (string2.equals("/")) {
                string2 = "/index.html";
                logger.trace((Object)("received uri of / changing to " + string2));
            }
            logger.trace((Object)string2);
            String string3 = httpServletRequest.getContextPath();
            if (string3 != null) {
                string2 = string2.substring(string3.length());
            }
            if ((template = this.templateFactory_.getTemplate(string = this.replaceExtension(string2))) != null) {
                template.setUrl(string2);
                TemplateEditorDataModel templateEditorDataModel = new TemplateEditorDataModel(httpServletRequest, httpServletResponse, template);
                if (this.frameTemplate_ == null) {
                    template.write((OutputStream)httpServletResponse.getOutputStream(), (Object)templateEditorDataModel);
                } else {
                    this.frameTemplate_.write((OutputStream)httpServletResponse.getOutputStream(), (Object)templateEditorDataModel);
                }
            } else {
                httpServletResponse.setStatus(404);
            }
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap((Throwable)iOException);
        }
    }

    private String replaceExtension(String string) {
        if (this.replaceExtension_ == null) {
            return string;
        }
        int n = string.lastIndexOf(46);
        return string.substring(0, n) + '.' + this.replaceExtension_;
    }

    class TemplateEditorDataModel {
        HttpServletRequest request_;
        HttpServletResponse response_;
        BrowserProperties browserProperties_;
        Template body_;

        TemplateEditorDataModel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Template template) {
            this.request_ = httpServletRequest;
            this.response_ = httpServletResponse;
            this.body_ = template;
            this.browserProperties_ = new BrowserProperties(this.request_.getHeader("user-agent"));
        }

        public String getBody() {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.body_.write(byteArrayOutputStream, (Object)this);
                String string = byteArrayOutputStream.toString();
                return string;
            }
            catch (Exception exception) {
                logger.error((Object)"error in body of template", (Object)exception);
                return "{{ error in body - " + exception.getMessage() + " }}";
            }
        }

        public BrowserProperties getBrowser() {
            return this.browserProperties_;
        }

        public String getServletUrl() {
            return this.request_.getServletPath();
        }

        public HttpServletRequest getRequest() {
            return this.request_;
        }

        public HttpServletResponse getResponse() {
            return this.response_;
        }

        public ServletContext getServletContext() {
            return TemplaterServlet.this.getServletContext();
        }

        public String getDomain() {
            return this.request_.getServerName();
        }
    }
}

