/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import net.model3.file.FileX;
import net.model3.lang.ExceptionPropagator;
import net.model3.templater.AbstractTag;
import net.model3.templater.FileBasedTemplateFactory;
import net.model3.templater.TemplateFactory;
import net.model3.templater.TemplateSource;

public class TemplateSourceFile
extends TemplateSource {
    private FileX file_;
    private long lastModifiedDate_;

    TemplateSourceFile(TemplateFactory templateFactory, FileX fileX) {
        super(templateFactory);
        this.file_ = fileX;
        FileX fileX2 = ((FileBasedTemplateFactory)templateFactory).getRoot();
        this.setName(fileX.getPathRelativeTo(fileX2));
    }

    @Override
    boolean exists() {
        return this.file_.exists() && this.file_.isFile();
    }

    @Override
    boolean hasBeenModified() {
        return this.file_.lastModified() != this.lastModifiedDate_;
    }

    @Override
    char[] asCharArray() {
        try {
            char[] cArray = new char[(int)this.file_.length()];
            FileReader fileReader = new FileReader(this.file_);
            int n = cArray.length;
            for (int i = 0; i < n; i += fileReader.read(cArray)) {
            }
            return cArray;
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap((Throwable)iOException);
        }
    }

    @Override
    void resetModificationFlag() {
        this.lastModifiedDate_ = this.file_.lastModified();
    }

    @Override
    void save() {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(this.file_));
            for (AbstractTag abstractTag = this.getTemplate().getFirstTag(); abstractTag != null; abstractTag = abstractTag.getNextTag()) {
                printStream.print(abstractTag.getText());
            }
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw ExceptionPropagator.wrap((Throwable)fileNotFoundException);
        }
    }

    File getParent() {
        return this.file_.getParentFile();
    }

    @Override
    TemplateSource createTemplateSource(String string) {
        FileX fileX;
        if (TemplateSourceFile.isLocationAbsolute(string)) {
            FileX fileX2 = ((FileBasedTemplateFactory)this.getFactory()).getRoot();
            string = TemplateSourceFile.removeLeadingFileSeparator(string);
            fileX = new FileX(fileX2, string);
        } else {
            fileX = new FileX(this.file_.getParentFile(), string);
        }
        return new TemplateSourceFile(this.getFactory(), fileX);
    }
}

