/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import net.model3.templater.LineCountingReader;
import net.model3.templater.Template;
import net.model3.templater.TemplateFactory;

public abstract class TemplateSource {
    private String name_;
    private TemplateFactory templateFactory_;
    private Template template_;
    private LineCountingReader lineCountingReader_;

    TemplateSource(TemplateFactory templateFactory) {
        this.templateFactory_ = templateFactory;
    }

    void setTemplate(Template template) {
        this.template_ = template;
    }

    Template getTemplate() {
        return this.template_;
    }

    String getName() {
        return this.name_;
    }

    void setName(String string) {
        this.name_ = string.toLowerCase();
    }

    LineCountingReader getReader() {
        if (this.lineCountingReader_ == null) {
            this.resetReader();
        }
        return this.lineCountingReader_;
    }

    void resetReader() {
        this.lineCountingReader_ = new LineCountingReader(this, this.asCharArray());
    }

    TemplateFactory getFactory() {
        return this.templateFactory_;
    }

    static boolean isLocationAbsolute(String string) {
        return string.startsWith("/") || string.startsWith("\\");
    }

    static String removeLeadingFileSeparator(String string) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == '\\'; ++n) {
        }
        while (n < string.length() && string.charAt(n) == '/') {
            ++n;
        }
        if (n > 0) {
            return string.substring(n);
        }
        return string;
    }

    abstract boolean exists();

    abstract boolean hasBeenModified();

    abstract void resetModificationFlag();

    abstract char[] asCharArray();

    abstract void save();

    abstract TemplateSource createTemplateSource(String var1);

    public String toString() {
        return this.name_;
    }
}

