/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import java.util.Hashtable;
import javax.servlet.Servlet;
import net.model3.bean.ReflectionTool;
import net.model3.file.FileX;
import net.model3.templater.FileBasedTemplateFactory;
import net.model3.templater.Template;
import net.model3.templater.TemplateSource;
import net.model3.templater.TextTemplate;

public abstract class TemplateFactory
implements net.model3.servlet.TemplateFactory {
    private Hashtable<String, Template> templateCache_ = new Hashtable();
    private Hashtable<String, TextTemplate> textTemplateCache_ = new Hashtable();
    private ReflectionTool beanTool_;

    public static TemplateFactory createFileBasedFactory(FileX fileX) {
        return new FileBasedTemplateFactory(fileX);
    }

    public static TemplateFactory createFileBasedFactory(FileX fileX, FileX fileX2) {
        return new FileBasedTemplateFactory(fileX, fileX2);
    }

    public static TemplateFactory createServletBasedFactory(Servlet servlet) {
        FileX fileX = new FileX(servlet.getServletConfig().getServletContext().getRealPath("/"));
        return new FileBasedTemplateFactory(fileX);
    }

    public Template getTemplate(String string) {
        return this.getTemplate(this.createTemplateSource(string));
    }

    Template getTemplate(TemplateSource templateSource) {
        if (!templateSource.exists()) {
            return null;
        }
        Template template = this.getTemplateFromCache(templateSource);
        if (template != null) {
            return template;
        }
        template = new Template(templateSource);
        this.addTemplateToCache(templateSource, template);
        return template;
    }

    TextTemplate getTextTemplate(TemplateSource templateSource) {
        TextTemplate textTemplate = this.getTextTemplateFromCache(templateSource);
        if (textTemplate != null) {
            return textTemplate;
        }
        textTemplate = new TextTemplate(templateSource);
        this.addTextTemplateToCache(templateSource, textTemplate);
        return textTemplate;
    }

    Template getTemplateFromCache(TemplateSource templateSource) {
        return this.templateCache_.get(templateSource.getName());
    }

    TextTemplate getTextTemplateFromCache(TemplateSource templateSource) {
        return this.textTemplateCache_.get(templateSource.getName());
    }

    void addTemplateToCache(TemplateSource templateSource, Template template) {
        this.templateCache_.put(templateSource.getName(), template);
    }

    void addTextTemplateToCache(TemplateSource templateSource, TextTemplate textTemplate) {
        this.textTemplateCache_.put(templateSource.getName(), textTemplate);
    }

    public abstract TemplateSource createTemplateSource(String var1);

    public ReflectionTool getBeanTool() {
        if (this.beanTool_ == null) {
            this.beanTool_ = new ReflectionTool(false);
        }
        return this.beanTool_;
    }

    public void setBeanTool(ReflectionTool reflectionTool) {
        this.beanTool_ = reflectionTool;
    }
}

