/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import java.io.OutputStream;
import java.io.PrintStream;
import net.model3.templater.AbstractTag;
import net.model3.templater.AbstractTemplate;
import net.model3.templater.EvaluationContext;
import net.model3.templater.Parser;
import net.model3.templater.TemplateSource;

public class Template
extends AbstractTemplate
implements net.model3.servlet.Template {
    private static final String TAG_START = "{{";
    private static final String TAG_END = "}}";
    private Parser parser_;
    private TemplateSource templateSource_;
    private boolean autoUpdate_;
    private String url_;

    public Template(TemplateSource templateSource) {
        this.templateSource_ = templateSource;
        templateSource.setTemplate(this);
        this.autoUpdate_ = true;
        this.resetTemplateDefinition();
    }

    public void setAutoUpdate(boolean bl) {
        this.autoUpdate_ = bl;
    }

    @Override
    public void write(OutputStream outputStream, Object object) {
        this.write(new PrintStream(outputStream), object);
    }

    @Override
    public void write(PrintStream printStream, Object object) {
        if (this.autoUpdate_) {
            this.updateDefinition();
        }
        EvaluationContext evaluationContext = new EvaluationContext(this.templateSource_.getFactory().getBeanTool(), object, printStream);
        this.parser_.getFirstTag().write(printStream, evaluationContext);
        printStream.flush();
    }

    @Override
    void updateDefinition() {
        if (this.isTemplateDefinitionChanged()) {
            this.resetTemplateDefinition();
        }
    }

    private boolean isTemplateDefinitionChanged() {
        return this.templateSource_.hasBeenModified();
    }

    private void resetTemplateDefinition() {
        this.parser_ = new Parser(this.templateSource_, TAG_START, TAG_END);
    }

    public void saveToDisk() {
        this.templateSource_.save();
        this.resetTemplateDefinition();
    }

    public void setUrl(String string) {
        this.url_ = string;
    }

    public String getUrl() {
        return this.url_;
    }

    AbstractTag getFirstTag() {
        return this.parser_.getFirstTag();
    }

    boolean isAutoUpdated() {
        return this.autoUpdate_;
    }

    TemplateSource getSource() {
        return this.templateSource_;
    }

    public String toString() {
        return this.templateSource_.toString();
    }
}

