/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.model3.templater.AbstractTag;
import net.model3.templater.LineCountingReader;
import net.model3.templater.ParsingException;
import net.model3.templater.SubroutineBeginTag;
import net.model3.templater.TagFactory;
import net.model3.templater.TagParseException;
import net.model3.templater.Template;
import net.model3.templater.TemplateFactory;
import net.model3.templater.TemplateSource;
import net.model3.templater.Token;
import net.model3.templater.TokenParsingException;

class Parser {
    private Stack<TemplateSource> includeStack_ = new Stack();
    private LineCountingReader currentReader_;
    private int specialTokenType_;
    private int specialTokenEndIndex_;
    private String visibleTagStart_;
    private String visibleTagEnd_;
    private String commentedTagEnd_;
    private String commentedTagStart_;
    private AbstractTag firstTag_;
    private AbstractTag previousTag_;
    private TemplateSource templateSource_;
    private TagFactory tagFactory_ = new TagFactory();
    private Map<String, SubroutineBeginTag> subroutineMap_ = new HashMap<String, SubroutineBeginTag>();

    Parser(TemplateSource templateSource, String string, String string2) throws ParsingException {
        this.templateSource_ = templateSource;
        this.setTagTokens(string, string2);
        templateSource.resetReader();
        this.pushReader(templateSource);
        this.loadTags();
        this.linkPhase();
        this.templateSource_.resetModificationFlag();
    }

    TemplateFactory getFactory() {
        return this.templateSource_.getFactory();
    }

    Template getTemplate() {
        return this.templateSource_.getTemplate();
    }

    AbstractTag getFirstTag() {
        return this.firstTag_;
    }

    String getStartTag() {
        return this.visibleTagStart_;
    }

    String getEndTag() {
        return this.visibleTagEnd_;
    }

    int getColumn() {
        return this.currentReader_.column();
    }

    int getRow() {
        return this.currentReader_.row();
    }

    String getPosition() {
        return this.currentReader_.getName() + " row: " + this.getRow() + " column: " + this.getColumn();
    }

    private Token nextToken() {
        int n;
        String string;
        if (this.endOfReaderStack()) {
            return null;
        }
        int n2 = this.currentReader_.row();
        int n3 = this.currentReader_.column();
        if (this.isAtSpecialToken()) {
            string = this.currentReader_.substring(this.currentReader_.position(), this.specialTokenEndIndex_);
            n = this.specialTokenType_;
            this.currentReader_.consumeTo(this.specialTokenEndIndex_);
        } else {
            int n4 = this.currentReader_.position();
            while (!this.isAtSpecialToken()) {
                this.currentReader_.consume();
                if (!this.endOfReaderStack()) continue;
            }
            string = this.currentReader_.substring(n4, this.currentReader_.position());
            n = 0;
        }
        return new Token(string, n, n2, n3, this.currentReader_.row(), this.currentReader_.column());
    }

    private boolean isAtSpecialToken() {
        if (this.isAtToken(this.commentedTagEnd_, 2)) {
            return true;
        }
        if (this.isAtToken(this.commentedTagStart_, 1)) {
            return true;
        }
        if (this.isAtToken(this.visibleTagEnd_, 2)) {
            return true;
        }
        return this.isAtToken(this.visibleTagStart_, 1);
    }

    private boolean isAtToken(String string, int n) {
        if (!this.currentReader_.isAt(string)) {
            return false;
        }
        this.specialTokenEndIndex_ = this.currentReader_.position() + string.length();
        this.specialTokenType_ = n;
        return true;
    }

    private void setTagTokens(String string, String string2) {
        this.visibleTagEnd_ = string2;
        this.visibleTagStart_ = string;
        this.commentedTagEnd_ = String.valueOf(String.valueOf(string2)).concat("-->");
        this.commentedTagStart_ = "<!--".concat(String.valueOf(String.valueOf(string)));
    }

    private void addTextTag(Token token) {
        this.tagAddedEvent(this.tagFactory_.createTextTag(this, token, this.previousTag_));
    }

    private void addTag(Token token, Token token2, Token token3) {
        Token[] tokenArray = new Token[]{token, token2, token3};
        AbstractTag abstractTag = this.tagFactory_.createTag(this, tokenArray, token2, this.previousTag_);
        this.tagAddedEvent(abstractTag);
    }

    private void tagAddedEvent(AbstractTag abstractTag) {
        if (this.firstTag_ == null) {
            this.firstTag_ = abstractTag;
        }
        this.previousTag_ = abstractTag;
    }

    private void loadTags() throws TagParseException {
        Token token;
        this.firstTag_ = null;
        while ((token = this.nextToken()) != null) {
            if (token.isText()) {
                this.addTextTag(token);
                continue;
            }
            if (token.isTagStart()) {
                Token token2 = token;
                Token token3 = this.nextToken();
                Token token4 = this.nextToken();
                if (!token3.isText()) {
                    throw new TokenParsingException("text token expected", token3, this.currentReader_.getTemplateSource());
                }
                if (!token4.isTagEnd()) {
                    throw new TokenParsingException("end keyword expected", token4, this.currentReader_.getTemplateSource());
                }
                this.addTag(token2, token3, token4);
                continue;
            }
            throw new TokenParsingException("start keyword expected", token, this.currentReader_.getTemplateSource());
        }
    }

    private boolean endOfReaderStack() {
        boolean bl;
        block2: {
            while (this.currentReader_.endOfStream()) {
                if (this.includeStack_.isEmpty()) {
                    bl = true;
                    break block2;
                }
                this.currentReader_ = this.includeStack_.pop().getReader();
            }
            bl = false;
        }
        return bl;
    }

    private void pushReader(TemplateSource templateSource) {
        this.includeStack_.push(templateSource);
        this.currentReader_ = templateSource.getReader();
    }

    public void addSubroutine(SubroutineBeginTag subroutineBeginTag) {
        this.subroutineMap_.put(subroutineBeginTag.getName(), subroutineBeginTag);
    }

    public SubroutineBeginTag getSubroutine(String string) {
        return this.subroutineMap_.get(string);
    }

    private void linkPhase() throws TagParseException {
        for (AbstractTag abstractTag = this.firstTag_; abstractTag != null; abstractTag = abstractTag.getNextTag()) {
            abstractTag.linkPhase();
        }
    }

    public String toString() {
        return this.templateSource_.toString();
    }
}

