/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.model3.templater.AbstractBeginTag;
import net.model3.templater.AbstractEndTag;
import net.model3.templater.AbstractTag;
import net.model3.templater.EvaluationContext;
import net.model3.templater.EvaluationException;
import net.model3.templater.Expression;
import net.model3.templater.LoopEndTag;
import net.model3.templater.LoopIterateAlwaysTag;
import net.model3.templater.TagParseException;

class LoopBeginTag
extends AbstractBeginTag {
    private String iteratorName_;
    private LoopIterateAlwaysTag iterateAlwaysTag_;
    private Expression collectionExpression_;

    LoopBeginTag() {
    }

    @Override
    void initImpl() {
        List<String> list = this.getTokenizedParms();
        if (list.size() != 3) {
            throw new TagParseException(this, "need 3 tokens for " + this);
        }
        if (!list.get(1).equalsIgnoreCase("as")) {
            throw new TagParseException(this, "second token must be as " + this);
        }
        this.iteratorName_ = list.get(2);
        this.collectionExpression_ = new Expression(this, list.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    AbstractTag writeTag(PrintStream printStream, EvaluationContext evaluationContext) {
        try {
            Object object;
            Iterator iterator = this.collectionExpression_.evaluate(evaluationContext);
            if (iterator instanceof List) {
                iterator = ((List)((Object)iterator)).iterator();
            } else if (iterator instanceof Object[]) {
                object = new ArrayList();
                Collections.addAll(object, (Object[])iterator);
                iterator = object.iterator();
            } else if (!(iterator instanceof Iterator)) {
                throw new EvaluationException(this, "field " + this.getFirstToken() + " in the data model can not be iterated.");
            }
            try {
                object = iterator;
                evaluationContext.registerIterator(this.iteratorName_, (Iterator)object);
                while (evaluationContext.iterate(this.iteratorName_)) {
                    this.write(this.getNextTag(), printStream, evaluationContext);
                }
            }
            finally {
                evaluationContext.unregisterIterator(this.iteratorName_);
                evaluationContext.unregisterVariable(this.iteratorName_);
            }
        }
        catch (EvaluationException evaluationException) {
            evaluationContext.handleError(evaluationException);
        }
        return this.getEndTag().getNextTag();
    }

    @Override
    void setEndTag(AbstractEndTag abstractEndTag) {
        super.setEndTag(abstractEndTag);
        if (!this.iteratorName_.equalsIgnoreCase(((LoopEndTag)abstractEndTag).loopName_)) {
            throw new TagParseException(this, "end_loop doesn't match begin loop " + abstractEndTag);
        }
    }

    @Override
    String getKeyword() {
        return "begin_loop";
    }

    LoopIterateAlwaysTag getIterateAlwaysTag() {
        return this.iterateAlwaysTag_;
    }

    String getIteratorName() {
        return this.iteratorName_;
    }

    void setIterateAlwaysTag(LoopIterateAlwaysTag loopIterateAlwaysTag) {
        this.iterateAlwaysTag_ = loopIterateAlwaysTag;
    }
}

