/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import java.io.File;
import java.io.FileWriter;
import net.model3.templater.InternalProblem;
import net.model3.templater.TemplateSource;

public class LineCountingReader {
    private TemplateSource templateSource_;
    private char[] charArray_;
    private int index_;
    private int column_;
    private int row_;
    private String name_;

    public LineCountingReader(TemplateSource templateSource, char[] cArray) {
        this.charArray_ = cArray;
        this.column_ = 1;
        this.row_ = 1;
        this.index_ = 0;
        this.templateSource_ = templateSource;
    }

    public int length() {
        return this.charArray_.length;
    }

    public char peekChar() {
        return this.charArray_[this.index_];
    }

    public char nextChar() {
        char c = this.charArray_[this.index_];
        this.consume();
        return c;
    }

    public String substring(int n, int n2) {
        int n3 = n2 - n;
        String string = new String(this.charArray_, n, n3);
        return string;
    }

    public void consumeTo(int n) {
        if (n < this.index_) {
            throw new InternalProblem("new index of " + n + " less than current index " + this.index_);
        }
        while (n != this.index_) {
            this.consume();
        }
    }

    public int position() {
        return this.index_;
    }

    public boolean endOfStream() {
        return this.index_ >= this.charArray_.length;
    }

    public int indexof(String string) {
        int n = 0;
        for (int i = this.index_; i < this.charArray_.length; ++i) {
            if (this.charArray_[i] == string.charAt(n)) {
                if (++n != string.length()) continue;
                return i - string.length() + 1;
            }
            n = 0;
        }
        return -1;
    }

    public boolean isAt(String string) {
        try {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (this.charArray_[this.index_ + i] == string.charAt(i)) continue;
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        return true;
    }

    public int row() {
        return this.row_;
    }

    public int column() {
        return this.column_;
    }

    public void consume() {
        ++this.index_;
        if (this.index_ < this.charArray_.length) {
            ++this.column_;
            boolean bl = false;
            if (this.charArray_[this.index_] == '\n') {
                bl = true;
            }
            if (this.charArray_[this.index_] == '\r') {
                if (this.index_ + 1 < this.charArray_.length) {
                    if (this.charArray_[this.index_ + 1] != '\n') {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                ++this.row_;
                this.column_ = 1;
            }
        }
    }

    String getName() {
        return this.name_;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 13;
        int n2 = 10;
        int n3 = 10;
        int n4 = 13;
        File file = new File("test");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("\r\n");
        fileWriter.close();
        System.out.println(file.getCanonicalPath());
    }

    TemplateSource getTemplateSource() {
        return this.templateSource_;
    }
}

