/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import java.util.Map;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.templater.AbstractTag;
import net.model3.templater.EvaluationContext;
import net.model3.templater.ExpressionEvaluationException;
import net.model3.templater.ExpressionParsingException;
import net.model3.templater.OgnlX;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.SimpleNode;

public class Expression {
    private static final Logger logger = LoggerHelper.getLogger();
    private String expression_;
    private SimpleNode expressionAst_;
    private AbstractTag tag_;

    public Expression(AbstractTag abstractTag, String string) throws ExpressionParsingException {
        this.tag_ = abstractTag;
        this.expression_ = string;
        try {
            this.expressionAst_ = (SimpleNode)Ognl.parseExpression((String)string);
        }
        catch (OgnlException ognlException) {
            throw new ExpressionParsingException(this.tag_, OgnlX.getHumanReadableMessage(ognlException), ognlException);
        }
    }

    public SimpleNode getExpressionAst() {
        return this.expressionAst_;
    }

    Object evaluate(EvaluationContext evaluationContext) throws ExpressionEvaluationException {
        return this.evaluate(evaluationContext, null);
    }

    boolean evaluateAsBoolean(EvaluationContext evaluationContext) throws ExpressionEvaluationException {
        return (Boolean)this.evaluate(evaluationContext, Boolean.TYPE);
    }

    private Object evaluate(EvaluationContext evaluationContext, Class clazz) throws ExpressionEvaluationException {
        try {
            return Ognl.getValue((Object)this.getExpressionAst(), (Map)evaluationContext.getOgnlContext(), (Object)evaluationContext.getDataModelRoot(), (Class)clazz);
        }
        catch (OgnlException ognlException) {
            throw new ExpressionParsingException(this.tag_, OgnlX.getHumanReadableMessage(ognlException), ognlException);
        }
    }

    public String asString() {
        return this.expression_;
    }

    public String toString() {
        return this.tag_.getTemplate().getSource().getName() + this.tag_.getStartPosition() + "'" + this.expression_ + "'";
    }
}

