/*
 * Decompiled with CFR 0.152.
 */
package net.model3.templater;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.templater.EvaluationContext;
import net.model3.templater.Parser;
import net.model3.templater.TagParseException;
import net.model3.templater.Template;
import net.model3.templater.TemplateFactory;
import net.model3.templater.Token;

abstract class AbstractTag {
    private static final Logger logger = LoggerHelper.getLogger();
    private AbstractTag previousTag_;
    private AbstractTag nextTag_;
    private Token[] tokens_;
    private Token tagBodyToken_;
    private String parms_;
    private List<String> tokenizedParms_;
    private Parser parser_;

    AbstractTag() {
    }

    AbstractTag(Token[] tokenArray, Parser parser, AbstractTag abstractTag) {
        this.tokens_ = tokenArray;
        this.parser_ = parser;
        this.previousTag_ = abstractTag;
        if (abstractTag != null) {
            abstractTag.nextTag_ = this;
        }
    }

    TemplateFactory getFactory() {
        return this.parser_.getFactory();
    }

    Template getTemplate() {
        return this.parser_.getTemplate();
    }

    public String toString() {
        return this.getTemplate().getSource().getName() + this.getStartPosition() + '[' + this.getText() + ']';
    }

    protected void linkPhase() throws TagParseException {
    }

    void write(PrintStream printStream, EvaluationContext evaluationContext) {
        this.write(this, printStream, evaluationContext);
    }

    void write(AbstractTag abstractTag, PrintStream printStream, EvaluationContext evaluationContext) {
        while (abstractTag != null) {
            try {
                abstractTag = abstractTag.writeTag(printStream, evaluationContext);
            }
            catch (Exception exception) {
                printStream.print(this.parser_.getStartTag());
                printStream.print(exception.getMessage());
                printStream.print(this.parser_.getEndTag());
                abstractTag = abstractTag.nextTag_;
            }
        }
    }

    String getFirstToken() {
        if (this.getTokenizedParms().size() > 0) {
            return this.getTokenizedParms().get(0);
        }
        return null;
    }

    abstract AbstractTag writeTag(PrintStream var1, EvaluationContext var2);

    abstract void initImpl() throws TagParseException;

    List<String> getTokenizedParms() {
        if (this.tokenizedParms_ == null) {
            ParmTokenizer parmTokenizer = new ParmTokenizer(this.parms_);
            this.tokenizedParms_ = parmTokenizer.tokens_;
        }
        return this.tokenizedParms_;
    }

    List<AbstractTag> searchForAllTags(Class clazz) {
        return this.searchForAllTags(clazz, null);
    }

    List<AbstractTag> searchForAllTags(Class clazz, AbstractTag abstractTag) {
        ArrayList<AbstractTag> arrayList = new ArrayList<AbstractTag>();
        AbstractTag abstractTag2 = this;
        while (abstractTag2 != null) {
            if (abstractTag2.getClass().getName().equals(clazz.getName())) {
                arrayList.add(abstractTag2);
            }
            if (abstractTag2 == abstractTag) break;
            abstractTag2 = abstractTag2.nextTag_;
        }
        return arrayList;
    }

    AbstractTag searchForPreviousTag(Class clazz) {
        AbstractTag abstractTag = this;
        do {
            if ((abstractTag = abstractTag.previousTag_) != null) continue;
            return null;
        } while (!abstractTag.getClass().equals(clazz));
        return abstractTag;
    }

    AbstractTag getPreviousTag() {
        return this.previousTag_;
    }

    final void init(Token[] tokenArray, Token token, String string, Parser parser, AbstractTag abstractTag) {
        this.tokens_ = tokenArray;
        this.tagBodyToken_ = token;
        this.parms_ = string;
        this.parser_ = parser;
        this.previousTag_ = abstractTag;
        if (this.previousTag_ != null) {
            abstractTag.nextTag_ = this;
        }
        this.initImpl();
    }

    abstract String getKeyword();

    String getTagBodyText() {
        return this.tagBodyToken_.getText();
    }

    Parser getTemplateTokenizer() {
        return this.parser_;
    }

    AbstractTag getNextTag() {
        return this.nextTag_;
    }

    String getParms() {
        return this.parms_;
    }

    void setParms(String string) {
        this.parms_ = string;
    }

    String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token : this.tokens_) {
            stringBuilder.append(token.getText());
        }
        return stringBuilder.toString();
    }

    String getStartPosition() {
        if (this.tokens_.length > 0) {
            return this.tokens_[0].getStartPosition();
        }
        return "";
    }

    class ParmTokenizer {
        List<String> tokens_ = new ArrayList<String>();
        int index_;

        ParmTokenizer(String string) {
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            char c = '\u0000';
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (bl) {
                    if (c2 != c) continue;
                    this.tokens_.add(string.substring(n, i + 1));
                    n = i + 1;
                    bl = false;
                    continue;
                }
                if (bl2) {
                    if (!Character.isWhitespace(c2)) continue;
                    this.tokens_.add(string.substring(n, i));
                    bl2 = false;
                    n = i + 1;
                    continue;
                }
                if (c2 == '\'' || c2 == '\"') {
                    bl = true;
                    c = c2;
                    n = i;
                    continue;
                }
                if (Character.isWhitespace(c2)) continue;
                n = i;
                bl2 = true;
            }
            if (bl) {
                throw new TagParseException(AbstractTag.this, "unenclosed string literal in " + string);
            }
            if (bl2) {
                this.tokens_.add(string.substring(n));
            }
        }

        int count() {
            return this.tokens_.size() - this.index_;
        }

        String nextToken() {
            if (this.index_ >= this.tokens_.size()) {
                return null;
            }
            String string = this.tokens_.get(this.index_);
            ++this.index_;
            return string;
        }
    }
}

