/*
 * Decompiled with CFR 0.152.
 */
package net.model3.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class FormLayout
implements LayoutManager {
    private static final int COMPONENT = 0;
    private static final int BOTTOM = 1;
    private static final int LEFT = 2;
    private static final int HCENTER = 3;
    private static final int VCENTER = 4;
    private static final int RIGHT = 5;
    private static final int TOP = 6;
    private static final int BITSET = 7;
    private static final int DIMENSION = 8;
    private static final int NAME = 9;
    private static final int FORM = -32765;
    private static final int INVALID = -32766;
    private static final int UNBOUND = -32767;
    private static final boolean m_debug = false;
    private static final boolean m_bigDebug = false;
    private String m_myName = this.getClass().getName();
    private Dimension m_formDimensions;
    private Point m_formLocation;
    private Vector m_tuples;
    private Hashtable m_nameToIndex;
    private List constraintList_;
    private boolean m_changedFlag;

    @Override
    public void addLayoutComponent(String string, Component component) {
        Object[] objectArray = new Object[10];
        objectArray[0] = component;
        objectArray[7] = new BitSet();
        objectArray[9] = string;
        int n = this.m_tuples.size();
        this.m_tuples.addElement(objectArray);
        this.m_nameToIndex.put(string, new Integer(n));
        this.m_changedFlag = true;
    }

    private final int evaluate(String string) throws Exception {
        String string2;
        int n = 1;
        int n2 = 0;
        int n3 = string.indexOf(43);
        if (n3 == -1) {
            n3 = string.indexOf(45);
            n = -1;
        }
        if (n3 == -1) {
            n2 = this.getAttr(string);
        } else if (n3 > 1) {
            string2 = string.substring(0, n3);
            n2 = this.getAttr(string2);
        }
        if (n3 != -1 && n2 != -32767) {
            string2 = string.substring(n3 + 1);
            int n4 = Integer.parseInt(string2, 10);
            n2 += n * n4;
        }
        return n2;
    }

    private final boolean explicit(BitSet bitSet) throws Exception {
        boolean bl = false;
        if (this.constraintList_ == null || this.constraintList_.size() == 0) {
            throw new Exception("no constraints (explicit)");
        }
        for (int i = 0; i < this.constraintList_.size(); ++i) {
            try {
                String string;
                if (bitSet.get(i)) continue;
                String string2 = this.getConstraint(i);
                int n = string2.indexOf(61);
                if (n < 3) {
                    throw new Exception("invalid constraint, expected '=': " + string2 + "(explicit)");
                }
                String string3 = string2.substring(0, n);
                if (this.setAttr(string3, this.evaluate(string = string2.substring(n + 1)))) {
                    bitSet.set(i);
                    continue;
                }
                bl = true;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("error in constraint[" + i + "] " + this.getConstraint(i));
            }
        }
        return !bl;
    }

    private final int getAttr(int n, int n2) {
        int n3 = -32767;
        if (n == -32765) {
            if (n2 == 1) {
                n3 = this.m_formLocation.y + this.m_formDimensions.height;
            } else if (n2 == 2) {
                n3 = this.m_formLocation.x;
            } else if (n2 == 3) {
                n3 = this.m_formLocation.x + this.m_formDimensions.width / 2;
            } else if (n2 == 4) {
                n3 = this.m_formLocation.y + this.m_formDimensions.height / 2;
            } else if (n2 == 5) {
                n3 = this.m_formLocation.x + this.m_formDimensions.width;
            } else if (n2 == 6) {
                n3 = this.m_formLocation.y;
            }
        } else if (this.isBound(n, n2)) {
            Object[] objectArray = (Object[])this.m_tuples.elementAt(n);
            n3 = (Integer)objectArray[n2];
        }
        return n3;
    }

    private final int getAttr(String string) throws Exception {
        int[] nArray = this.parseAttr(string);
        int n = this.getAttr(nArray[0], nArray[1]);
        return n;
    }

    private final int getAttrNr(String string) {
        int n = -32766;
        if (string.equals("bottom")) {
            n = 1;
        } else if (string.equals("left") || string.equals("x")) {
            n = 2;
        } else if (string.equals("hcenter") || string.equals("c")) {
            n = 3;
        } else if (string.equals("vcenter")) {
            n = 4;
        } else if (string.equals("right")) {
            n = 5;
        } else if (string.equals("top") || string.equals("y")) {
            n = 6;
        }
        return n;
    }

    private final BitSet getBitset(int n) {
        Object[] objectArray = (Object[])this.m_tuples.elementAt(n);
        return (BitSet)objectArray[7];
    }

    private final Component getComponent(int n) {
        Object[] objectArray = (Object[])this.m_tuples.elementAt(n);
        return (Component)objectArray[0];
    }

    private final String getComponentName(int n) {
        Object[] objectArray = (Object[])this.m_tuples.elementAt(n);
        return (String)objectArray[9];
    }

    private final int getComponentNr(String string) throws Exception {
        Object v = this.m_nameToIndex.get(string);
        if (v == null) {
            throw new Exception("component not found: '" + string + "' (getComponentNr)");
        }
        return (Integer)v;
    }

    private final Dimension getDimension(int n) {
        Dimension dimension;
        Object[] objectArray = (Object[])this.m_tuples.elementAt(n);
        if (objectArray[8] == null) {
            Component component = (Component)objectArray[0];
            dimension = component.getPreferredSize();
            objectArray[8] = dimension;
        } else {
            dimension = (Dimension)objectArray[8];
        }
        return dimension;
    }

    private final int getOppsOffset(int n, int n2) {
        int n3 = -32766;
        Dimension dimension = this.getDimension(n);
        if (n2 == 1) {
            n3 = -dimension.height;
        } else if (n2 == 2) {
            n3 = dimension.width;
        } else if (n2 == 5) {
            n3 = -dimension.width;
        } else if (n2 == 6) {
            n3 = dimension.height;
        }
        return n3;
    }

    private final int getRelsOffset(int n, int n2) {
        int n3 = -32766;
        Dimension dimension = this.getDimension(n);
        if (n2 == 3) {
            n3 = -dimension.width / 2;
        } else if (n2 == 2) {
            n3 = dimension.width / 2;
        } else if (n2 == 6) {
            n3 = dimension.height / 2;
        } else if (n2 == 4) {
            n3 = -dimension.height / 2;
        }
        return n3;
    }

    private final boolean implicit() throws Exception {
        boolean bl = false;
        for (int i = 0; i < this.m_tuples.size(); ++i) {
            for (int j = 1; j <= 6; ++j) {
                if (this.isMarked(i, j)) continue;
                int n = this.relative(j);
                if (n != -32766 && this.isBound(i, n)) {
                    this.setAttr(i, j, this.getAttr(i, n) + this.getRelsOffset(i, n));
                    continue;
                }
                int n2 = this.opposite(j);
                if (n2 != -32766 && this.isBound(i, n2)) {
                    this.setAttr(i, j, this.getAttr(i, n2) + this.getOppsOffset(i, n2));
                    continue;
                }
                bl = true;
            }
        }
        return !bl;
    }

    private final boolean isBound(int n, int n2) {
        BitSet bitSet = this.getBitset(n);
        return bitSet.get(n2);
    }

    private final boolean isMarked(int n, int n2) {
        BitSet bitSet = this.getBitset(n);
        return bitSet.get(n2 + 7);
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension = this.preferredLayoutSize(container);
        if (!this.m_changedFlag) {
            for (int i = 0; i < this.m_tuples.size(); ++i) {
                Object[] objectArray = (Object[])this.m_tuples.elementAt(i);
                int n = (Integer)objectArray[2];
                int n2 = (Integer)objectArray[6];
                int n3 = (Integer)objectArray[5] - n;
                int n4 = (Integer)objectArray[1] - n2;
                Component component = (Component)objectArray[0];
                component.setBounds(n, n2, n3, n4);
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    private final int opposite(int n) {
        int n2 = -32766;
        if (n == 1) {
            n2 = 6;
        } else if (n == 2) {
            n2 = 5;
        } else if (n == 5) {
            n2 = 2;
        } else if (n == 6) {
            n2 = 1;
        }
        return n2;
    }

    private final int[] parseAttr(String string) throws Exception {
        int n = string.indexOf(46);
        if (n < 1) {
            throw new Exception(this.m_myName + "invalid attribute, expected '.': '" + string + "' (parseAttr)");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int[] nArray = new int[]{string2.equals("form") ? -32765 : this.getComponentNr(string2), this.getAttrNr(string3)};
        return nArray;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = container.getSize().width - n;
        int n6 = container.getSize().height - n2;
        this.reshape(n3, n4, n5, n6);
        return new Dimension(this.m_formDimensions.width + n, this.m_formDimensions.height + n2);
    }

    private final int relative(int n) {
        int n2 = -32766;
        if (n == 3) {
            n2 = 2;
        } else if (n == 2) {
            n2 = 3;
        } else if (n == 6) {
            n2 = 4;
        } else if (n == 4) {
            n2 = 6;
        }
        return n2;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        int n = this.m_tuples.size();
        for (int i = 0; i < n; ++i) {
            if (this.getComponent(i) != component) continue;
            String string = this.getComponentName(i);
            this.m_nameToIndex.remove(string);
            this.m_changedFlag = true;
        }
    }

    private final void reconstrain() throws Exception {
        int n;
        BitSet bitSet = new BitSet();
        for (n = 0; n < this.m_tuples.size(); ++n) {
            Object[] objectArray = (Object[])this.m_tuples.elementAt(n);
            objectArray[8] = null;
            BitSet bitSet2 = (BitSet)objectArray[7];
            bitSet2.and(bitSet);
        }
        int n2 = 0;
        do {
            n = 0;
            if (!this.explicit(bitSet)) {
                n = 1;
            }
            if (this.implicit()) continue;
            n = 1;
        } while (n != 0 && ++n2 < 30);
        if (n != 0) {
            throw new Exception("possible loop in constraints, failed after " + n2 + " iterations (reconstrain)");
        }
        this.m_changedFlag = false;
    }

    private final void reshape(int n, int n2, int n3, int n4) {
        if (this.m_formDimensions.width != n3 || this.m_formDimensions.height != n4) {
            this.m_formDimensions.width = n3;
            this.m_formDimensions.height = n4;
            this.m_changedFlag = true;
        }
        if (this.m_formLocation.x != n || this.m_formLocation.y != n2) {
            this.m_formLocation.x = n;
            this.m_formLocation.y = n2;
            this.m_changedFlag = true;
        }
        if (this.m_changedFlag) {
            try {
                this.reconstrain();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(this.m_myName + " error: " + exception.getMessage() + "\n");
            }
        }
    }

    private final boolean setAttr(int n, int n2, int n3) throws Exception {
        if (n == -32765) {
            throw new Exception("invalid constraint, can't set attributes of form (setAtttr)");
        }
        this.setMarked(n, n2);
        boolean bl = false;
        if (n3 != -32767) {
            Object[] objectArray = (Object[])this.m_tuples.elementAt(n);
            objectArray[n2] = new Integer(n3);
            this.setBound(n, n2);
            bl = true;
        }
        return bl;
    }

    private final boolean setAttr(String string, int n) throws Exception {
        int[] nArray = this.parseAttr(string);
        return this.setAttr(nArray[0], nArray[1], n);
    }

    private final void setBound(int n, int n2) {
        BitSet bitSet = this.getBitset(n);
        bitSet.set(n2);
    }

    private final void setMarked(int n, int n2) {
        BitSet bitSet = this.getBitset(n);
        bitSet.set(n2 + 7);
    }

    public FormLayout(List list) {
        this.constraintList_ = list;
        this.m_formDimensions = new Dimension(0, 0);
        this.m_formLocation = new Point(0, 0);
        this.m_nameToIndex = new Hashtable();
        this.m_tuples = new Vector();
        this.m_changedFlag = true;
    }

    private String getConstraint(int n) {
        return (String)this.constraintList_.get(n);
    }
}

