/*
 * Decompiled with CFR 0.152.
 */
package net.model3.layout;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.Timer;
import net.model3.collections.CaseInsensitiveMapWrapper;
import net.model3.file.FileX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.layout.Attribute;
import net.model3.layout.BaseNode;
import net.model3.layout.ComponentConstraint;
import net.model3.layout.ConstraintLexer;
import net.model3.layout.ConstraintParser;
import net.model3.layout.ConstraintTreeWalker;
import net.model3.layout.LayoutRule;
import net.model3.layout.ParentNode;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class LM
implements LayoutManager2 {
    private static final Logger logger = LoggerHelper.getLogger(LM.class);
    private static final Vector instances_ = new Vector();
    private static Timer updateTimer_;
    private Map nameToComponentMap_ = new CaseInsensitiveMapWrapper();
    private Map componentToNameMap_ = new HashMap();
    private Map componentConstraintsMap_ = new HashMap();
    private HashMap constantsMap_ = new HashMap();
    private boolean validated_ = false;
    private Container parent_;
    private String name_;
    private String layoutDefinition_;
    private FileX file_;
    private long lastModified_;
    private boolean parsed_ = false;

    public LM(String string) {
        this.name_ = string;
    }

    public LM(String string, String string2) {
        this.name_ = string;
        this.layoutDefinition_ = string2;
        this.parse();
    }

    public LM(String string, FileX fileX) {
        this.name_ = string;
        this.file_ = fileX;
        instances_.add(this);
        this.parse();
    }

    private void parse() {
        try {
            Reader reader;
            this.parsed_ = true;
            logger.trace((Object)("parsing layout definition for " + this.name_));
            this.componentConstraintsMap_.clear();
            if (this.file_ != null) {
                this.lastModified_ = this.file_.lastModified();
                reader = new FileReader(this.file_);
            } else {
                reader = new StringReader(this.layoutDefinition_);
            }
            ConstraintLexer constraintLexer = new ConstraintLexer(reader);
            ConstraintParser constraintParser = new ConstraintParser(constraintLexer);
            constraintParser.constraint_list();
            ConstraintTreeWalker constraintTreeWalker = new ConstraintTreeWalker();
            constraintTreeWalker.setLayoutManager(this);
            constraintTreeWalker.constraintList(constraintParser.getAST());
            this.validate();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw ExceptionPropagator.wrap((Throwable)fileNotFoundException);
        }
        catch (RecognitionException recognitionException) {
            throw ExceptionPropagator.wrap((Throwable)recognitionException);
        }
        catch (TokenStreamException tokenStreamException) {
            throw ExceptionPropagator.wrap((Throwable)tokenStreamException);
        }
        logger.trace((Object)("parsing complete for " + this.name_));
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof String)) {
            throw new RuntimeException("invalid constraint.  constraint must be a string that is the name of the componenent to map between the name and the component instance");
        }
        this.addLayoutComponent((String)object, component);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return null;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.resetValues();
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.nameToComponentMap_.put(string, component);
        this.componentToNameMap_.put(component, string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        String string = (String)this.componentToNameMap_.remove(component);
        if (string != null) {
            this.componentToNameMap_.remove(string);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return null;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return null;
    }

    boolean layoutDefinitionUpdated() {
        return this.file_ != null && this.lastModified_ != this.file_.lastModified();
    }

    @Override
    public void layoutContainer(Container container) {
        if (!this.parsed_) {
            this.parse();
        }
        logger.trace((Object)("laying out " + this.name_));
        if (this.parent_ == null) {
            this.parent_ = container;
        } else if (container != this.parent_) {
            throw new RuntimeException("cannot layout multiple containers with a single instance");
        }
        if (this.layoutDefinitionUpdated()) {
            this.parse();
        }
        this.resetValues();
        for (ComponentConstraint componentConstraint : this.componentConstraintsMap_.values()) {
            componentConstraint.evaluate();
        }
    }

    Component getComponent(String string) {
        return (Component)this.nameToComponentMap_.get(string);
    }

    void addComponentConstraint(ComponentConstraint componentConstraint) {
        this.componentConstraintsMap_.put(componentConstraint.getName().toLowerCase(), componentConstraint);
        componentConstraint.setLayoutManager(this);
    }

    private void resetValues() {
        for (ComponentConstraint componentConstraint : this.componentConstraintsMap_.values()) {
            Component component;
            componentConstraint.reset();
            if (componentConstraint.hasComponent() || (component = this.getComponent(componentConstraint.getName())) == null) continue;
            componentConstraint.setComponent(component);
        }
    }

    private void validate() {
        for (ComponentConstraint componentConstraint : this.componentConstraintsMap_.values()) {
            componentConstraint.validate();
        }
        this.validated_ = true;
    }

    ComponentConstraint getComponentConstraint(String string) {
        return (ComponentConstraint)this.componentConstraintsMap_.get(string);
    }

    public static void main(String[] stringArray) {
        String string = "bob( l=1234, t=123412 )ted( l=bob.left, t=parent.top )";
        LM lM = new LM("test", string);
        boolean bl = true;
    }

    BaseNode getNode(String string, Attribute attribute) {
        if (string.equals("parent")) {
            return new ParentNode(this.parent_, attribute);
        }
        ComponentConstraint componentConstraint = this.getComponentConstraint(string);
        if (componentConstraint == null) {
            throw new RuntimeException("invalid name=" + string);
        }
        LayoutRule layoutRule = componentConstraint.getConstraint(attribute);
        return layoutRule.node();
    }

    String getName() {
        return this.name_;
    }

    public static void updateLayoutDefinitions() {
        Iterator iterator = instances_.iterator();
        while (iterator.hasNext()) {
            LM lM = null;
            try {
                lM = (LM)iterator.next();
                if (!lM.layoutDefinitionUpdated()) continue;
                lM.parse();
                if (lM.parent_ == null) continue;
                lM.parent_.doLayout();
            }
            catch (Exception exception) {
                logger.warn((Object)("error laying out " + lM.getName()), (Object)exception);
            }
        }
    }

    public static void startUpdateTimer(int n) {
        ThreadScheduler threadScheduler = (ThreadScheduler)DependencyInjector.get().getInstance(ThreadScheduler.class);
        TimeDuration timeDuration = TimeDuration.fromSeconds((double)n);
        threadScheduler.scheduleRepeating("updateLayoutDefinitions", timeDuration, new Runnable(){

            @Override
            public void run() {
                LM.updateLayoutDefinitions();
            }
        });
    }

    public void addLayoutConstant(String string, double d) {
        this.constantsMap_.put(string.toLowerCase(), new Double(d));
    }

    public double getConstantValue(String string) {
        Double d = (Double)this.constantsMap_.get(string.toLowerCase());
        if (d != null) {
            return d;
        }
        throw new RuntimeException("constant " + string + " not defined.");
    }

    static int getRecursionCheckThreshold() {
        return 100;
    }

    public String getLayoutDefinition() {
        return this.layoutDefinition_;
    }

    public void setLayoutDefinition(String string) {
        this.layoutDefinition_ = string;
    }
}

