/*
 * Decompiled with CFR 0.152.
 */
package net.model3.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import net.model3.layout.AddNode;
import net.model3.layout.Attribute;
import net.model3.layout.BaseNode;
import net.model3.layout.DivideNode;
import net.model3.layout.FloatNode;
import net.model3.layout.LM;
import net.model3.layout.LayoutRule;
import net.model3.layout.PreferredHeightNode;
import net.model3.layout.PreferredWidthNode;
import net.model3.layout.SubtractNode;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class ComponentConstraint {
    private static final Logger logger = LoggerHelper.getLogger(LayoutRule.class);
    private LayoutRule width_;
    private LayoutRule height_;
    private LayoutRule left_;
    private LayoutRule right_;
    private LayoutRule top_;
    private LayoutRule bottom_;
    private LayoutRule centerX_;
    private LayoutRule centerY_;
    private LayoutRule preferredWidth_;
    private LayoutRule preferredHeight_;
    private Component comp_;
    private List constraintList_ = new ArrayList();
    private String name_;
    private LM layoutManager_;

    ComponentConstraint(String string) {
        this.name_ = string;
    }

    void setLayoutManager(LM lM) {
        this.layoutManager_ = lM;
    }

    String getName() {
        return this.name_;
    }

    void reset() {
        this.right_.reset();
        this.left_.reset();
        this.width_.reset();
        this.height_.reset();
        this.top_.reset();
        this.bottom_.reset();
        this.centerX_.reset();
        this.centerY_.reset();
    }

    void addConstraint(Attribute attribute, BaseNode baseNode) {
        LayoutRule layoutRule = new LayoutRule(baseNode);
        this.constraintList_.add(layoutRule);
        if (attribute == Attribute.BOTTOM) {
            this.bottom_ = layoutRule;
        } else if (attribute == Attribute.HEIGHT) {
            this.height_ = layoutRule;
        } else if (attribute == Attribute.LEFT) {
            this.left_ = layoutRule;
        } else if (attribute == Attribute.RIGHT) {
            this.right_ = layoutRule;
        } else if (attribute == Attribute.TOP) {
            this.top_ = layoutRule;
        } else if (attribute == Attribute.WIDTH) {
            this.width_ = layoutRule;
        } else if (attribute == Attribute.CENTER_X) {
            this.centerX_ = layoutRule;
        } else if (attribute == Attribute.CENTER_Y) {
            this.centerY_ = layoutRule;
        }
    }

    boolean hasComponent() {
        return this.comp_ != null;
    }

    void setComponent(Component component) {
        if (this.hasComponent()) {
            throw new RuntimeException("already has a component");
        }
        if (component == null) {
            throw new RuntimeException("must pass a valid component");
        }
        this.comp_ = component;
    }

    void evaluate() {
        try {
            this.comp_.setBounds(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        }
        catch (NullPointerException nullPointerException) {
            logger.error((Object)("component is null for component constraint " + this.name_ + " layout " + this.layoutManager_.getName()));
        }
    }

    int getLeft() {
        try {
            return this.left_.value();
        }
        catch (RuntimeException runtimeException) {
            logger.warn((Object)("unable to retrieve value for " + this.name_ + ".left"), (Object)runtimeException);
            throw runtimeException;
        }
    }

    int getRight() {
        return this.right_.value();
    }

    int getWidth() {
        return this.width_.value();
    }

    int getHeight() {
        return this.height_.value();
    }

    int getTop() {
        return this.top_.value();
    }

    int getBottom() {
        return this.bottom_.value();
    }

    int getPreferredWidth() {
        if (this.comp_ != null) {
            Dimension dimension = this.comp_.getPreferredSize();
            if (dimension != null) {
                return dimension.width;
            }
            throw new RuntimeException("component named " + this.name_ + " does not have a preferred size and the layout constraints " + this.layoutManager_.getName() + " require a preferred size.");
        }
        throw new RuntimeException("no component named " + this.name_ + " found in " + this.layoutManager_.getName());
    }

    int getPreferredHeight() {
        if (this.comp_ != null) {
            Dimension dimension = this.comp_.getPreferredSize();
            if (dimension != null) {
                return dimension.height;
            }
            throw new RuntimeException("component named " + this.name_ + " does not have a preferred size and the layout constraints " + this.layoutManager_.getName() + " require a preferred size.");
        }
        throw new RuntimeException("no component named " + this.name_ + " found in " + this.layoutManager_.getName());
    }

    void validate() {
        if (this.centerX_ != null && (this.left_ != null || this.right_ != null)) {
            throw new RuntimeException(this.name_ + " has centerx with right or left");
        }
        if (this.centerX_ == null && this.left_ == null && this.right_ == null) {
            throw new RuntimeException("must specify a centerx, left or right attribute for " + this.name_);
        }
        if (this.centerY_ != null && (this.top_ != null || this.bottom_ != null)) {
            throw new RuntimeException("cannot specify center Y with top or bottom");
        }
        if (this.centerY_ == null && this.top_ == null && this.bottom_ == null) {
            throw new RuntimeException("must specify a top or bottom attribute.");
        }
        if (this.width_ == null) {
            this.width_ = this.left_ != null && this.right_ != null ? new LayoutRule(new SubtractNode(this.right_.node(), this.left_.node())) : this.getPreferredWidthRule();
        }
        if (this.height_ == null) {
            this.height_ = this.top_ != null && this.bottom_ != null ? new LayoutRule(new SubtractNode(this.bottom_.node(), this.top_.node())) : this.getPreferredHeightRule();
        }
        if (this.centerX_ == null) {
            if (this.right_ == null) {
                this.right_ = new LayoutRule(new AddNode(this.left_.node(), this.width_.node()));
            } else if (this.left_ == null) {
                this.left_ = new LayoutRule(new SubtractNode(this.right_.node(), this.width_.node()));
            }
            this.centerX_ = new LayoutRule(ComponentConstraint.createCenterNode(this.left_, this.right_));
        } else {
            this.right_ = new LayoutRule(ComponentConstraint.createEdgeNode(this.centerX_, this.width_, true));
            this.left_ = new LayoutRule(ComponentConstraint.createEdgeNode(this.centerX_, this.width_, false));
        }
        if (this.centerY_ == null) {
            if (this.bottom_ == null) {
                this.bottom_ = new LayoutRule(new AddNode(this.top_.node(), this.height_.node()));
            } else if (this.top_ == null) {
                this.top_ = new LayoutRule(new SubtractNode(this.bottom_.node(), this.height_.node()));
            }
            this.centerY_ = new LayoutRule(ComponentConstraint.createCenterNode(this.top_, this.bottom_));
        } else {
            this.bottom_ = new LayoutRule(ComponentConstraint.createEdgeNode(this.centerY_, this.height_, true));
            this.top_ = new LayoutRule(ComponentConstraint.createEdgeNode(this.centerY_, this.height_, false));
        }
    }

    LayoutRule getConstraint(Attribute attribute) {
        if (attribute == Attribute.BOTTOM) {
            return this.bottom_;
        }
        if (attribute == Attribute.HEIGHT) {
            return this.height_;
        }
        if (attribute == Attribute.LEFT) {
            return this.left_;
        }
        if (attribute == Attribute.RIGHT) {
            return this.right_;
        }
        if (attribute == Attribute.TOP) {
            return this.top_;
        }
        if (attribute == Attribute.WIDTH) {
            return this.width_;
        }
        if (attribute == Attribute.CENTER_X) {
            return this.centerX_;
        }
        if (attribute == Attribute.CENTER_Y) {
            return this.centerY_;
        }
        if (attribute == Attribute.PHEIGHT) {
            return this.getPreferredHeightRule();
        }
        if (attribute == Attribute.PWIDTH) {
            return this.getPreferredWidthRule();
        }
        throw new RuntimeException("unsupported atribute " + attribute.getName());
    }

    private static BaseNode createCenterNode(LayoutRule layoutRule, LayoutRule layoutRule2) {
        AddNode addNode = new AddNode(layoutRule.node(), layoutRule2.node());
        DivideNode divideNode = new DivideNode(addNode, new FloatNode(2.0));
        return divideNode;
    }

    private static BaseNode createEdgeNode(LayoutRule layoutRule, LayoutRule layoutRule2, boolean bl) {
        int n = bl ? 2 : -2;
        DivideNode divideNode = new DivideNode(layoutRule2.node(), new FloatNode(n));
        AddNode addNode = new AddNode(layoutRule.node(), divideNode);
        return addNode;
    }

    LayoutRule getPreferredWidthRule() {
        if (this.preferredWidth_ == null) {
            this.preferredWidth_ = new LayoutRule(new PreferredWidthNode(this));
        }
        return this.preferredWidth_;
    }

    LayoutRule getPreferredHeightRule() {
        if (this.preferredHeight_ == null) {
            this.preferredHeight_ = new LayoutRule(new PreferredHeightNode(this));
        }
        return this.preferredHeight_;
    }
}

