/*
 * Decompiled with CFR 0.152.
 */
package net.model3.layout;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.model3.layout.LM;

final class AttributeStack {
    private static ThreadLocal threadLocals_ = new ThreadLocal();
    private final int recursionCheckThreshHold_ = LM.getRecursionCheckThreshold();
    private final List stack_ = new ArrayList(this.recursionCheckThreshHold_);

    AttributeStack() {
    }

    static AttributeStack getInstance() {
        AttributeStack attributeStack = (AttributeStack)threadLocals_.get();
        if (attributeStack == null) {
            attributeStack = new AttributeStack();
            threadLocals_.set(attributeStack);
        }
        return attributeStack;
    }

    void push(String string) {
        this.stack_.add(string);
        if (this.stack_.size() > 0 && this.stack_.size() % this.recursionCheckThreshHold_ == 0) {
            this.checkForRecursion();
        }
    }

    void pop() {
        this.stack_.remove(this.stack_.size() - 1);
    }

    void clear() {
        this.stack_.clear();
    }

    private void checkForRecursion() {
        HashSet hashSet = new HashSet();
        int n = this.stack_.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.stack_.get(i);
            if (hashSet.contains(e)) {
                String string = (String)e;
                throw new RuntimeException("recursive call in " + string);
            }
            hashSet.add(e);
        }
    }
}

