/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang.reflect;

import java.util.concurrent.ConcurrentHashMap;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.reflect.IClass;
import net.model3.lang.reflect.ReflectionProvider;

public abstract class AbstractReflectionProvider
implements ReflectionProvider {
    private ConcurrentHashMap<Class<?>, IClass> _classMap = new ConcurrentHashMap();

    private Class<?> loadClass(String string) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    @Override
    public boolean canProvideFor(String string) {
        return true;
    }

    @Override
    public boolean canProvideFor(Class<?> clazz) {
        return true;
    }

    @Override
    public IClass<?> get(String string) {
        return this.get(this.loadClass(string));
    }

    @Override
    public <T> IClass<T> get(Class<T> clazz) {
        IClass<T> iClass = this._classMap.get(clazz);
        if (iClass == null) {
            iClass = this.createIClass(clazz);
        }
        return iClass;
    }

    protected abstract <T> IClass<T> createIClass(Class<T> var1);
}

