/*
 * Decompiled with CFR 0.152.
 */
package net.model3.hibernate3.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.DateX;
import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;

public class DateXType
extends ImmutableType {
    private static final Logger logger = LoggerHelper.getLogger();

    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        try {
            Timestamp timestamp = resultSet.getTimestamp(string);
            if (timestamp != null) {
                DateX dateX = new DateX(timestamp);
                return dateX;
            }
            return null;
        }
        catch (SQLException sQLException) {
            int n = resultSet.findColumn(string);
            String string2 = resultSet.getMetaData().getTableName(n);
            String string3 = resultSet.getMetaData().getColumnLabel(n);
            String string4 = "";
            try {
                string4 = resultSet.getString(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.warn(new Object[]{"error translating TIMESTAMP to DateX returning null.  Table and column {}.{}='{}'", string2, string3, string4, sQLException});
            return null;
        }
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        DateX dateX = (DateX)object;
        preparedStatement.setTimestamp(n, new Timestamp(dateX.getTimeInMillis()));
    }

    public int sqlType() {
        return 93;
    }

    public Class getReturnedClass() {
        return DateX.class;
    }

    public boolean equals(Object object, Object object2) throws HibernateException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        DateX dateX = (DateX)object;
        DateX dateX2 = (DateX)object2;
        return dateX.getTimeInMillis() == dateX2.getTimeInMillis();
    }

    public String getName() {
        return "DateX";
    }

    public Object fromStringValue(String string) throws HibernateException {
        DateX dateX = new DateX(string);
        return dateX;
    }

    public String toString(Object object) throws HibernateException {
        return object.toString();
    }
}

