/*
 * Decompiled with CFR 0.152.
 */
package net.model3.hibernate3;

import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.model3.collections.PropertiesX;
import net.model3.collections.PropertyLoader;
import net.model3.hibernate3.HibernateInterceptor;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;

public class HibernateSession {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final ThreadLocal<org.hibernate.Session> threadLocalSession_ = new ThreadLocal();
    private static boolean useHibernateDotConfigDotXml_ = true;
    private static SessionFactoryImplementor sessionFactory_;
    private static Dialect dialect_;
    private static PropertiesX properties_;
    private static Configuration configuration_;
    private static List<Class> persistedClasses_;
    private static String jdbcUrl_;
    private static Directory configDirectory_;
    private static Object initSemaphore_;
    private static Throwable initializationStackTrace_;

    public static Dialect getDialect() {
        return dialect_;
    }

    public static void addPersistedClass(Class clazz) {
        logger.debug((Object)("adding persisted class " + clazz.getName()));
        persistedClasses_.add(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init() {
        Object object = initSemaphore_;
        synchronized (object) {
            if (configuration_ == null || sessionFactory_ == null) {
                logger.debug((Object)"initializing hibernate");
                try {
                    configuration_ = new Configuration();
                    Iterator<Class> iterator = persistedClasses_.iterator();
                    while (iterator.hasNext()) {
                        configuration_.addClass(iterator.next());
                    }
                    configuration_.setProperties(HibernateSession.getProperties());
                    if (useHibernateDotConfigDotXml_) {
                        configuration_.configure();
                    }
                    sessionFactory_ = (SessionFactoryImplementor)configuration_.buildSessionFactory();
                    dialect_ = Dialect.getDialect((Properties)HibernateSession.getProperties());
                    initializationStackTrace_ = new Throwable();
                }
                catch (MappingException mappingException) {
                    logger.fatal((Object)"", (Object)mappingException);
                    throw new RuntimeException(mappingException);
                }
                catch (HibernateException hibernateException) {
                    logger.fatal((Object)"", (Object)hibernateException);
                    throw new RuntimeException(hibernateException);
                }
            } else {
                logger.debug((Object)"original initializationStackTrace_", (Object)initializationStackTrace_);
                logger.warn((Object)"hibernate already initialized see previous log message for stack trace of original initialization", (Object)new Throwable());
            }
        }
    }

    public static Configuration getConfiguration() {
        if (configuration_ == null) {
            HibernateSession.init();
        }
        return configuration_;
    }

    public static synchronized void commitCurrentSession() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"flushing and committing session started");
        }
        try {
            org.hibernate.Session session = HibernateSession.currentSession();
            session.flush();
            if (!session.connection().getAutoCommit()) {
                session.connection().commit();
            }
        }
        catch (HibernateException hibernateException) {
            logger.error((Object)"", (Object)hibernateException);
            throw ExceptionPropagator.wrap((Throwable)hibernateException);
        }
        catch (SQLException sQLException) {
            logger.error((Object)"", (Object)sQLException);
            throw ExceptionPropagator.wrap((Throwable)sQLException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"flushing and committing session completed");
        }
    }

    public static org.hibernate.Session currentSession() {
        try {
            org.hibernate.Session session;
            if (sessionFactory_ == null) {
                HibernateSession.init();
            }
            if ((session = threadLocalSession_.get()) != null && !session.isOpen()) {
                threadLocalSession_.set(null);
                session = null;
            }
            if (session == null) {
                session = HibernateSession.newSession();
                threadLocalSession_.set(session);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("current session returned " + session));
            }
            return session;
        }
        catch (HibernateException hibernateException) {
            throw ExceptionPropagator.wrap((Throwable)hibernateException);
        }
    }

    public static void setCurrentSession(org.hibernate.Session session) {
        org.hibernate.Session session2 = threadLocalSession_.get();
        if (session != null && session.isOpen()) {
            String string = "this thread already has a session.  you must close it first before setting the current session.";
            logger.error((Object)string);
            throw new RuntimeException(string);
        }
        threadLocalSession_.set(session);
    }

    public static List fetchMany(Class clazz, String string) {
        try {
            Query query = HibernateSession.currentSession().createQuery("select this from " + clazz.getName() + " as this where " + string);
            return query.list();
        }
        catch (HibernateException hibernateException) {
            throw ExceptionPropagator.wrap((Throwable)hibernateException);
        }
    }

    public static <T> List<T> fetchAll(Class<T> clazz) {
        try {
            Query query = HibernateSession.currentSession().createQuery("select this from " + clazz.getName() + " as this");
            List list = query.list();
            return list;
        }
        catch (HibernateException hibernateException) {
            throw ExceptionPropagator.wrap((Throwable)hibernateException);
        }
    }

    public static <T> T fetch(Class<T> clazz, String string) {
        try {
            Query query = HibernateSession.currentSession().createQuery("select this from " + clazz.getName() + " as this where " + string);
            List list = query.list();
            switch (list.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (T)list.get(0);
                }
            }
            throw new RuntimeException("fetch found more than 1 instance of " + clazz.getName() + " from query " + string);
        }
        catch (HibernateException hibernateException) {
            throw ExceptionPropagator.wrap((Throwable)hibernateException);
        }
    }

    public static void setThreadLocalSession(org.hibernate.Session session) {
        threadLocalSession_.set(session);
    }

    public static org.hibernate.Session newSession() throws HibernateException {
        if (sessionFactory_ == null) {
            HibernateSession.init();
        }
        Session session = sessionFactory_.openSession((Interceptor)new HibernateInterceptor());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("new session created " + session));
        }
        return session;
    }

    public static boolean hasActiveSession() {
        org.hibernate.Session session = threadLocalSession_.get();
        return session != null;
    }

    public static void closeSession() {
        org.hibernate.Session session = HibernateSession.currentSession();
        threadLocalSession_.set(null);
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception exception) {
                logger.error((Object)"error closing session", (Object)exception);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("session closed " + session));
            }
        }
    }

    public static Properties getProperties() {
        if (properties_ == null) {
            HibernateSession.initProperties();
        }
        return properties_;
    }

    private static void initProperties() {
        if (properties_ != null) {
            return;
        }
        properties_ = new PropertiesX();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("hibernate.properties");
        if (inputStream != null) {
            try {
                properties_.load(inputStream);
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        if (configDirectory_ != null) {
            PropertyLoader.loadProperties((Directory)configDirectory_, (String)"hibernate", (Properties)properties_);
        }
        properties_.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.HashtableCacheProvider");
        jdbcUrl_ = properties_.getProperty("hibernate.connection.url");
    }

    public static SessionFactory getSessionFactory() {
        return HibernateSession.getSessionFactoryImplementor();
    }

    public static SessionFactoryImplementor getSessionFactoryImplementor() {
        if (sessionFactory_ == null) {
            HibernateSession.init();
        }
        return sessionFactory_;
    }

    public static void setSessionFactory(SessionFactoryImplementor sessionFactoryImplementor) {
        sessionFactory_ = sessionFactoryImplementor;
    }

    public static String getJdbcUser() {
        return HibernateSession.getProperties().getProperty("hibernate.connection.username");
    }

    public static String getJdbcPassword() {
        return HibernateSession.getProperties().getProperty("hibernate.connection.password");
    }

    public static String getJdbcUrl() {
        if (jdbcUrl_ == null) {
            HibernateSession.initProperties();
        }
        return jdbcUrl_;
    }

    public static String getJdbcDriver() {
        return HibernateSession.getProperties().getProperty("hibernate.connection.driver_class");
    }

    public static void setConfigDirectory(Directory directory) {
        configDirectory_ = directory;
    }

    public static <T> T load(Class<T> clazz, Long l) {
        return HibernateSession.load(clazz, (Serializable)l);
    }

    public static <T> T load(Class<T> clazz, Serializable serializable) {
        if (serializable != null) {
            try {
                return (T)HibernateSession.currentSession().get(clazz, serializable);
            }
            catch (HibernateException hibernateException) {
                throw ExceptionPropagator.wrap((Throwable)hibernateException);
            }
        }
        return null;
    }

    public static <T> T load(Class<T> clazz, long l) {
        return HibernateSession.load(clazz, (Serializable)new Long(l));
    }

    public static void executeSqlUpdate(String string) {
        Statement statement = null;
        try {
            statement = HibernateSession.currentSession().connection().createStatement();
            statement.executeUpdate(string);
        }
        catch (Exception exception) {
            logger.error((Object)("error executing sql update " + string));
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    logger.error((Object)"error closing statement", (Object)sQLException);
                }
            }
        }
    }

    public static void setUseHibernateDotConfigDotXml(boolean bl) {
        useHibernateDotConfigDotXml_ = bl;
    }

    static {
        persistedClasses_ = new ArrayList<Class>();
        initSemaphore_ = new Object();
    }
}

