/*
 * Decompiled with CFR 0.152.
 */
package net.model3.hibernate3;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.model3.hibernate3.PersistentObject;
import net.model3.logging.Level;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.DateX;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

public class HibernateInterceptor
extends EmptyInterceptor {
    private static final Logger logger = LoggerHelper.getLogger(HibernateInterceptor.class);
    private final Set addedEntities_ = new HashSet();
    private final Set deletedEntities_ = new HashSet();
    private final Set changedEntities_ = new HashSet();

    public Boolean isTransient(Object object) {
        if (object instanceof PersistentObject) {
            if (((PersistentObject)object).isUnsaved()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public void onDelete(Object object, Serializable serializable, Object[] objectArray, String[] stringArray, Type[] typeArray) throws CallbackException {
        this.deletedEntities_.add(object);
    }

    public boolean onFlushDirty(Object object, Serializable serializable, Object[] objectArray, Object[] objectArray2, String[] stringArray, Type[] typeArray) throws CallbackException {
        boolean bl = false;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!stringArray[i].equals("lastChangeTimestamp") && !stringArray[i].equals("lastChangeTimestamp_")) continue;
            objectArray[i] = new DateX();
            bl = true;
            break;
        }
        this.changedEntities_.add(object);
        return bl;
    }

    public boolean onLoad(Object object, Serializable serializable, Object[] objectArray, String[] stringArray, Type[] typeArray) throws CallbackException {
        return false;
    }

    public boolean onSave(Object object, Serializable serializable, Object[] objectArray, String[] stringArray, Type[] typeArray) throws CallbackException {
        this.addedEntities_.add(object);
        return false;
    }

    public void postFlush(Iterator iterator) throws CallbackException {
        if (logger.isDebugEnabled()) {
            this.logEntities("inserted", this.addedEntities_.iterator(), Level.DEBUG);
            this.logEntities("updated", this.changedEntities_.iterator(), Level.DEBUG);
            this.logEntities("deleted", this.deletedEntities_.iterator(), Level.DEBUG);
        }
        if (logger.isTraceEnabled()) {
            this.logEntities("flushed", iterator, Level.TRACE);
        }
        for (Object e : this.addedEntities_) {
            if (!(e instanceof PersistentObject)) continue;
            ((PersistentObject)e).setUnsaved(false);
        }
        for (Object e : this.deletedEntities_) {
            if (!(e instanceof PersistentObject)) continue;
            ((PersistentObject)e).setUnsaved(true);
        }
        this.addedEntities_.clear();
        this.deletedEntities_.clear();
        this.changedEntities_.clear();
    }

    private void logEntities(String string, Iterator iterator, Level level) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof PersistentObject)) continue;
            PersistentObject persistentObject = (PersistentObject)e;
            logger.log(level, new Object[]{string + " " + persistentObject.getQualifiedKeyName()});
        }
    }
}

