/*
 * Decompiled with CFR 0.152.
 */
package net.model3.hibernate3;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.model3.lang.ClassX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;

public class FieldAccessor
implements Setter,
Getter {
    private static final Logger logger = LoggerHelper.getLogger();
    Field _field;
    private String _classname;
    private String _fieldname;

    public FieldAccessor(Field field) {
        this._classname = field.getDeclaringClass().getName();
        this._fieldname = field.getName();
        this._field = field;
        this._field.setAccessible(true);
    }

    private void resetField() {
        try {
            Class<?> clazz = Class.forName(this._classname);
            Field field = ClassX.getField(clazz, (String)this._fieldname);
            field.setAccessible(true);
            this._field = field;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Field getField() {
        return this._field;
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return this.getField().getName();
    }

    public void set(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        try {
            this.getField().set(object, object2);
            return;
        }
        catch (Exception exception) {
            throw new HibernateException((Throwable)exception);
        }
    }

    public Class getReturnType() {
        return this.getField().getType();
    }

    public Object get(Object object) throws HibernateException {
        try {
            return this.getField().get(object);
        }
        catch (Exception exception) {
            throw new HibernateException((Throwable)exception);
        }
    }

    public Object getForInsert(Object object, Map map, SessionImplementor sessionImplementor) throws HibernateException {
        return this.get(object);
    }
}

