/*
 * Decompiled with CFR 0.152.
 */
package net.model3.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.model3.hibernate.HibernateSession;
import net.model3.hibernate.PersistentObject;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.Tokenizer;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.type.NullableType;

public class StringToLazySetType<T>
extends NullableType {
    private static final Logger logger = LoggerHelper.getLogger();
    private Class elementClass_;

    protected StringToLazySetType(Class<T> clazz) {
        this.elementClass_ = clazz;
    }

    public Object deepCopyNotNull(Object object) throws HibernateException {
        return new HashSet((Set)object);
    }

    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        String string2 = resultSet.getString(string);
        if (string2 == null) {
            return null;
        }
        return this.fromStringValue(string2);
    }

    public void set(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        preparedStatement.setString(n, this.toString(object));
    }

    public String getName() {
        return "lazy-set";
    }

    public Class getReturnedClass() {
        return Set.class;
    }

    public boolean hasNiceEquals() {
        return true;
    }

    public boolean isMutable() {
        return true;
    }

    public String toString(Object object) {
        return this.convertSetToUids((Set)object);
    }

    public Object fromStringValue(String string) {
        return new LazySet(string);
    }

    public int sqlType() {
        return 12;
    }

    public boolean equals(Object object, Object object2) throws HibernateException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.getClass().getName().equals(object2.getClass().getName()) && object.equals(object2);
    }

    String convertSetToUids(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        for (PersistentObject persistentObject : set) {
            stringBuffer.append(":");
            stringBuffer.append(persistentObject.getUid());
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    void convertUidsToSet(String string, Set set) {
        Tokenizer tokenizer = new Tokenizer(string, ":");
        while (tokenizer.next()) {
            String string2 = tokenizer.currentToken();
            if (StringX.isBlank((String)string2)) continue;
            try {
                Long l = new Long(string2);
                PersistentObject persistentObject = HibernateSession.load(this.elementClass_, l);
                if (persistentObject == null) {
                    logger.error((Object)("cannot find " + this.elementClass_.getName() + "@" + l));
                    continue;
                }
                set.add(persistentObject);
            }
            catch (Exception exception) {
                logger.error((Object)("error processing '" + tokenizer.currentToken() + "' in '" + string + "' into a set of " + this.elementClass_.getName()), (Object)exception);
            }
        }
    }

    class LazySet
    implements Set {
        private HashSet delegate_ = new HashSet();
        private String setAsString_;

        LazySet(String string) {
            this.setAsString_ = string;
        }

        @Override
        public boolean add(Object object) {
            this.load();
            return this.delegate_.add(object);
        }

        @Override
        public boolean addAll(Collection collection) {
            this.load();
            return this.delegate_.addAll(collection);
        }

        @Override
        public void clear() {
            this.setAsString_ = null;
            this.delegate_.clear();
        }

        @Override
        public boolean contains(Object object) {
            this.load();
            return this.delegate_.contains(object);
        }

        @Override
        public boolean containsAll(Collection collection) {
            this.load();
            return this.delegate_.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            this.load();
            return this.delegate_.isEmpty();
        }

        @Override
        public Iterator iterator() {
            this.load();
            return this.delegate_.iterator();
        }

        @Override
        public boolean remove(Object object) {
            this.load();
            return this.delegate_.remove(object);
        }

        @Override
        public boolean removeAll(Collection collection) {
            this.load();
            return this.delegate_.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection collection) {
            this.load();
            return this.delegate_.retainAll(collection);
        }

        @Override
        public int size() {
            this.load();
            return this.delegate_.size();
        }

        @Override
        public Object[] toArray() {
            this.load();
            return this.delegate_.toArray();
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            this.load();
            return this.delegate_.toArray(objectArray);
        }

        void load() {
            if (this.setAsString_ == null) {
                return;
            }
            StringToLazySetType.this.convertUidsToSet(this.setAsString_, this.delegate_);
            this.setAsString_ = null;
        }

        String getSetAsString() {
            if (this.setAsString_ == null) {
                return StringToLazySetType.this.convertSetToUids(this.delegate_);
            }
            return this.setAsString_;
        }

        void setSetAsString(String string) {
            this.setAsString_ = string;
        }
    }
}

