/*
 * Decompiled with CFR 0.152.
 */
package net.model3.hibernate.hbmxml;

import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.model3.bean.ClassHelper;
import net.model3.bean.ReflectionTool;
import net.model3.file.FileX;
import net.model3.file.WildCardFilter;
import net.model3.hibernate.PersistentObject;
import net.model3.hibernate.SuffixAddingPropertyAccessor;
import net.model3.hibernate.hbmxml.Column;
import net.model3.hibernate.hbmxml.ColumnCustomizer;
import net.model3.hibernate.hbmxml.Property;
import net.model3.hibernate.type.BigDecimalType;
import net.model3.hibernate.type.DateXType;
import net.model3.hibernate.type.MoneyType;
import net.model3.hibernate.type.TimeDurationType;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.sf.hibernate.type.TimeZoneType;
import net.sf.hibernate.type.Type;

public class HibernateHbmXmlProcessor {
    private static final Logger logger = LoggerHelper.getLogger(HibernateHbmXmlProcessor.class);
    private static final String FOREIGN_KEY_SUFFIX = "uid";
    private static final String PROP_QUOTE_NAMES = "hbmxml.quote-names";
    private static final String PROP_DEFAULT_ACCESS = "hbmxml.default-access";
    private static final String PROP_REMOVE_SUFFIX = "hbmxml.remove-suffix";
    private ReflectionTool beanTool_ = new ReflectionTool(false);
    private boolean modified_ = false;
    private Map<Class, Class> typeMapper_ = new HashMap<Class, Class>();
    private Boolean quoteNames_;
    private String defaultAccess_;
    private boolean writeResults_ = true;

    HibernateHbmXmlProcessor() {
        this.addTypeMapping(BigDecimalType.class);
        this.addTypeMapping(DateXType.class);
        this.addTypeMapping(MoneyType.class);
        this.addTypeMapping(TimeZoneType.class);
        this.addTypeMapping(TimeDurationType.class);
        this.defaultAccess_ = System.getProperty(PROP_DEFAULT_ACCESS, "field");
    }

    void addTypeMapping(Class clazz) {
        try {
            Type type = (Type)clazz.newInstance();
            this.typeMapper_.put(type.getReturnedClass(), clazz);
            logger.info((Object)("defining mapping  " + StringX.padRight((Object)type.getReturnedClass().getName(), (int)30, (boolean)false) + "  to  " + clazz.getName()));
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((String)("error processing type mapping for " + clazz.getName()), (Throwable)exception);
        }
    }

    boolean hasTypeMapping(String string) {
        try {
            return this.typeMapper_.containsKey(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ExceptionPropagator.wrap((Throwable)classNotFoundException);
        }
    }

    Class getTypeMapping(Class clazz) {
        return this.typeMapper_.get(clazz);
    }

    public void processFile(FileX fileX) {
        try {
            System.out.println("processing file " + fileX.getPath());
            Document document = new Document((File)fileX);
            Element element = document.getRoot();
            Elements elements = element.getElements("class");
            while (elements.hasMoreElements()) {
                this.processClass(elements.next());
            }
            if (this.writeResults_ && this.modified_) {
                fileX.write(document.toString());
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    private void processProperty(Class clazz, Element element) {
        try {
            Object object;
            String string = element.getAttribute("name");
            Class clazz2 = this.getType(element.getAttribute("type"));
            if (clazz2 == null) {
                clazz2 = this.getType(clazz, string);
                element.setAttribute("type", clazz2.getName());
                this.modified_ = true;
            }
            String string2 = this.processPropertyName(clazz, element, clazz2);
            String string3 = element.getAttribute("column");
            if (string3 == null) {
                string3 = this.processColumnName(string2);
            }
            if (string3 != null) {
                element.setAttribute("column", this.quoteSqlName(string3));
            }
            System.out.print("        property=" + StringX.padRight((Object)string2, (int)15, (boolean)false) + "  type=" + StringX.padRight((Object)clazz2.getName(), (int)30, (boolean)false));
            if (clazz2.equals(Boolean.TYPE) || clazz2.equals(Boolean.class)) {
                element.removeAttribute("column");
                object = element.addElement("column");
                object.setAttribute("name", this.quoteSqlName(string3));
                object.setAttribute("sql-type", "tinyint");
                object.setAttribute("not-null", String.valueOf(clazz2.isPrimitive()));
            } else if (clazz2.isPrimitive() && !element.getTagName().equals("version")) {
                element.removeAttribute("column");
                object = element.addElement("column");
                object.setAttribute("name", this.quoteSqlName(string3));
                object.setAttribute("not-null", String.valueOf(true));
            } else if (string3.equalsIgnoreCase(string2) && PersistentObject.class.isAssignableFrom(clazz2)) {
                element.setAttribute("column", this.addForeignKeySuffix(string));
            }
            object = this.getTypeMapping(clazz2);
            if (object != null) {
                this.modified_ = true;
                element.setAttribute("type", ((Class)object).getName());
                Object t = ((Class)object).newInstance();
                if (t instanceof ColumnCustomizer && element.getElement("column") == null) {
                    ColumnCustomizer columnCustomizer = (ColumnCustomizer)t;
                    Property property = new Property();
                    property.setColumn(element.getAttribute("column"));
                    property.setLength(element.getAttribute("length"));
                    property.setName(element.getAttribute("name"));
                    property.setType(element.getAttribute("type"));
                    Column column = columnCustomizer.customizeColumnDefinition(property);
                    if (column != null) {
                        element.removeAttribute("column");
                        Element element2 = element.addElement("column");
                        element2.setAttribute("name", this.quoteSqlName(column.getName()));
                        element2.setAttribute("sql-type", column.getSqlType());
                        element2.setAttribute("not-null", String.valueOf(!column.isNullable()));
                    }
                }
                System.out.println("  --> " + ((Class)object).getName());
            } else {
                System.out.println();
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    private String processPropertyName(Class clazz, Element element, Class clazz2) {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("access");
        if (string2.equals("method")) {
            string2 = "property";
            element.setAttribute("access", string2);
            this.modified_ = true;
        }
        if (string2.equals("property")) {
            if (!this.hasBeanMethods(clazz, string)) {
                this.hasBeanMethods(clazz, string);
                throw new RuntimeException("error unable to find field or getter/setter pair for " + clazz.getName() + "." + string);
            }
        } else if (string2.equals("field")) {
            if (!this.hasField(clazz, string)) {
                String string3 = string + "_";
                if (!this.hasField(clazz, string3)) {
                    throw new RuntimeException("error field not found " + clazz.getName() + "." + string);
                }
                string = string3;
            }
            if (string.charAt(string.length() - 1) == '_' && System.getProperty(PROP_REMOVE_SUFFIX, "true").equals("true")) {
                string = string.substring(0, string.length() - 1);
                element.setAttribute("access", SuffixAddingPropertyAccessor.class.getName());
                element.setAttribute("name", string);
                this.modified_ = true;
            }
        }
        return string;
    }

    void processDirectory(FileX fileX, boolean bl) {
        System.out.println("processing directory " + fileX.getCanonicalPath());
        Iterator<FileX> iterator = fileX.iterator(bl, false, new WildCardFilter("*.hbm.xml"));
        while (iterator.hasNext()) {
            this.processFile(iterator.next());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new SimpleLoggingConfigurator().addConsoleAppender();
        HibernateHbmXmlProcessor hibernateHbmXmlProcessor = new HibernateHbmXmlProcessor();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            for (int j = 0; j < stringArray2.length; ++j) {
                String string = stringArray2[j].trim();
                if (string.length() == 0) continue;
                Class<?> clazz = Class.forName(string);
                hibernateHbmXmlProcessor.addTypeMapping(clazz);
            }
        }
        hibernateHbmXmlProcessor.processDirectory(new FileX("."), true);
    }

    void processClass(Element element) {
        try {
            String string = element.getAttribute("name");
            Class<?> clazz = Class.forName(string);
            String string2 = element.getAttribute("table");
            if (string2 == null && element.getName().equals("class")) {
                string2 = ClassX.getShortName((String)string).toLowerCase();
            }
            element.setAttribute("table", this.quoteSqlName(string2));
            this.processSubElements(clazz, element.getElements());
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    void processComponent(Class clazz, Element element) {
        String string = element.getAttribute("class");
        String string2 = element.getAttribute("name");
        Class clazz2 = this.getType(string);
        if (clazz2 == null) {
            clazz2 = this.getType(clazz, string2);
        }
        String string3 = this.processPropertyName(clazz, element, clazz2);
        this.processSubElements(clazz2, element.getElements());
    }

    void processSubClass(Class clazz, Element element) {
        String string = element.getAttribute("name");
        Class clazz2 = this.getType(string);
        this.processSubElements(clazz2, element.getElements());
    }

    private void processSubElements(Class clazz, Elements elements) {
        while (elements.hasMoreElements()) {
            Element element = elements.next();
            String string = element.getName();
            if (string.equals("property")) {
                this.setAccessAttribute(element);
                this.processProperty(clazz, element);
                continue;
            }
            if (string.equals("set")) {
                this.setAccessAttribute(element);
                this.processSet(clazz, element);
                continue;
            }
            if (string.equals("map")) {
                this.setAccessAttribute(element);
                this.processMap(clazz, element);
                continue;
            }
            if (string.equals("many-to-one")) {
                this.setAccessAttribute(element);
                this.processManyToOne(clazz, element);
                continue;
            }
            if (string.equals("id")) {
                this.setAccessAttribute(element);
                continue;
            }
            if (string.equals("list")) {
                this.setAccessAttribute(element);
                continue;
            }
            if (string.equals("discriminator")) continue;
            if (string.equals("component")) {
                this.setAccessAttribute(element);
                this.processComponent(clazz, element);
                continue;
            }
            if (string.equals("version")) {
                this.setAccessAttribute(element);
                this.processProperty(clazz, element);
                element.removeAttribute("not-null");
                continue;
            }
            if (string.equals("cache")) continue;
            if (string.equals("subclass")) {
                this.processSubClass(clazz, element);
                continue;
            }
            throw new RuntimeException("don't know how to handle element " + string);
        }
    }

    boolean hasField(Class clazz, String string) {
        return this.beanTool_.getClassHelper(clazz).getField(string) != null;
    }

    boolean hasBeanMethods(Class clazz, String string) {
        string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        String string2 = "get" + string;
        String string3 = "set" + string;
        ClassHelper classHelper = this.beanTool_.getClassHelper(clazz);
        Method method = null;
        try {
            method = classHelper.getMethod(string2, 0, Boolean.valueOf(false), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method == null) {
            string2 = "is" + string;
            method = classHelper.getMethod(string2, 0, Boolean.valueOf(false), false);
            if (method == null) {
                string2 = "has" + string;
                method = classHelper.getMethod(string2, 0, Boolean.valueOf(false), false);
            }
            if (method != null && !method.getReturnType().equals(Boolean.TYPE) && !method.getReturnType().equals(Boolean.class)) {
                throw new RuntimeException("boolean method name does not return a boolean " + method);
            }
        }
        if (method == null) {
            return false;
        }
        Method method2 = classHelper.getMethod(string3, new Class[]{method.getReturnType()});
        if (method2 == null) {
            return false;
        }
        return method2.getReturnType().getName().equals("void");
    }

    void processSet(Class clazz, Element element) {
        String string = this.addForeignKeySuffix(ClassX.getShortName((Class)clazz).toLowerCase());
        Element element2 = element.getElement("one-to-many");
        if (element2 == null) {
            System.err.println("error not one-to-many element found in set");
            return;
        }
        Class clazz2 = this.getType(element2.getAttribute("class"));
        String string2 = this.processPropertyName(clazz, element, clazz2);
        Element element3 = element.getElement("key");
        String string3 = element3.getAttribute("column");
        if (string3 == null || string3.trim().length() == 0) {
            element3.setAttribute("column", string);
        }
    }

    void processMap(Class clazz, Element element) {
        String string = this.addForeignKeySuffix(ClassX.getShortName((Class)clazz).toLowerCase());
        Element element2 = element.getElement("one-to-many");
        if (element2 != null) {
            Element element3;
            String string2;
            Class clazz2 = this.getType(element2.getAttribute("class"));
            String string3 = this.processPropertyName(clazz, element, clazz2);
            Element element4 = element.getElement("key");
            String string4 = element4.getAttribute("column");
            if (string4.trim().length() == 0) {
                element4.setAttribute("column", string);
            }
            if ((string2 = (element3 = element.getElement("index")).getAttribute("column")).trim().length() == 0) {
                element4.setAttribute("column", string);
            }
        }
    }

    void processManyToOne(Class clazz, Element element) {
        String string = element.getAttribute("name");
        Class clazz2 = this.getType(element.getAttribute("class"));
        if (clazz2 == null) {
            clazz2 = this.getType(clazz, string);
            element.setAttribute("class", clazz2.getName());
            this.modified_ = true;
        }
        String string2 = this.processPropertyName(clazz, element, clazz2);
        String string3 = element.getAttribute("column");
        if (string3 == null) {
            string3 = this.processColumnName(string2);
        }
        if (string3.equals(string2)) {
            string3 = this.addForeignKeySuffix(string3);
            element.setAttribute("column", string3);
            this.modified_ = true;
        }
    }

    Class getType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ExceptionPropagator.wrap((Throwable)classNotFoundException);
        }
    }

    String quoteSqlName(String string) {
        if (this.quoteNames_ == null) {
            String string2 = System.getProperty(PROP_QUOTE_NAMES);
            this.quoteNames_ = string2 == null ? Boolean.TRUE : new Boolean(string2);
            logger.debug((Object)("quoteNames=" + this.quoteNames_));
        }
        if (this.quoteNames_.booleanValue() && !string.startsWith("`")) {
            return "`" + string + "`";
        }
        return string;
    }

    Class getType(Class clazz, String string) {
        ClassHelper classHelper = this.beanTool_.getClassHelper(clazz);
        Field field = classHelper.getField(string);
        if (field == null) {
            field = this.beanTool_.getClassHelper(clazz).getField(string + "_");
        }
        if (field != null) {
            return field.getType();
        }
        String string2 = string.charAt(0) + string.substring(1);
        Method method = classHelper.getMethod("get" + string2);
        if (method == null) {
            method = classHelper.getMethod("is" + string2);
        }
        if (method != null) {
            return method.getReturnType();
        }
        field = this.beanTool_.getClassHelper(clazz).getField(string + "_");
        throw new RuntimeException("unable to determine type for " + clazz.getName() + "." + string);
    }

    String processColumnName(String string) {
        return string;
    }

    String addForeignKeySuffix(String string) {
        string = string.endsWith("_") ? string + FOREIGN_KEY_SUFFIX : string + "_" + FOREIGN_KEY_SUFFIX;
        return this.quoteSqlName(string);
    }

    void setAccessAttribute(Element element) {
        String string;
        String string2 = string = element.getAttribute("access");
        if (string == null) {
            string2 = this.defaultAccess_;
        }
        if (string2.equals("method")) {
            string2 = "property";
        }
        if (!string2.equals(string)) {
            element.setAttribute("access", string2);
            this.modified_ = true;
        }
    }
}

