/*
 * Decompiled with CFR 0.152.
 */
package net.model3.hibernate;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.model3.hibernate.HibernateSession;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;

public class UidGenerator {
    private static final Logger logger = LoggerHelper.getLogger(UidGenerator.class);
    private static UidGenerator instance_ = new UidGenerator();
    private String tableName_ = "unique_id";
    private String columnName_ = "last_max";
    private String querySql_;
    private String updateSql_;
    private int increment_ = 100;
    private long minimum_;
    private Long maximum_;
    private long counter_;

    public static UidGenerator getInstance() {
        return instance_;
    }

    private String getInsertSql() {
        return "INSERT INTO " + this.tableName_ + " ( " + this.columnName_ + " ) values( 100 )";
    }

    private String getQuerySql() {
        if (this.querySql_ == null) {
            this.querySql_ = "select " + this.columnName_ + " from " + this.tableName_;
        }
        return this.querySql_;
    }

    private String getUpdateSql() {
        if (this.updateSql_ == null) {
            this.updateSql_ = "update " + this.tableName_ + " set " + this.columnName_ + " = ? where " + this.columnName_ + " = ?";
        }
        return this.updateSql_;
    }

    public synchronized Long next() {
        this.checkMaximum(null);
        Long l = this.nextImpl();
        return l;
    }

    private Long nextImpl() {
        Long l = new Long(this.counter_);
        ++this.counter_;
        return l;
    }

    private void checkMaximum(Connection connection) {
        if (this.maximum_ == null || this.counter_ == this.maximum_) {
            if (connection == null) {
                this.nextSet();
            } else {
                this.nextSet(connection);
            }
        }
    }

    public synchronized Long next(Connection connection) {
        this.checkMaximum(connection);
        Long l = this.nextImpl();
        return l;
    }

    private void nextSet() {
        Session session = null;
        try {
            session = HibernateSession.newSession();
            Connection connection = session.connection();
            this.nextSet(connection);
        }
        catch (HibernateException hibernateException) {
            throw ExceptionPropagator.wrap((Throwable)hibernateException);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (HibernateException hibernateException) {
                    throw ExceptionPropagator.wrap((Throwable)hibernateException);
                }
            }
        }
    }

    private void nextSet(Connection connection) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        try {
            do {
                AutoCloseable autoCloseable;
                try (PreparedStatement preparedStatement = connection.prepareStatement(this.getQuerySql());){
                    autoCloseable = preparedStatement.executeQuery();
                    if (!autoCloseable.next()) {
                        PreparedStatement preparedStatement2 = connection.prepareStatement(this.getInsertSql());
                        preparedStatement2.executeUpdate();
                        preparedStatement2.close();
                        continue;
                    }
                    l = autoCloseable.getLong(1);
                    autoCloseable.close();
                }
                autoCloseable = connection.prepareStatement(this.getUpdateSql());
                try {
                    l2 = l + (long)this.increment_;
                    autoCloseable.setLong(1, l2);
                    autoCloseable.setLong(2, l);
                    n = autoCloseable.executeUpdate();
                }
                catch (SQLException sQLException) {
                    logger.error((Object)("could not update hi value in: " + this.tableName_), (Object)sQLException);
                    throw ExceptionPropagator.wrap((Throwable)sQLException);
                }
                finally {
                    autoCloseable.close();
                }
            } while (n == 0);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            this.maximum_ = new Long(l2);
            this.counter_ = this.minimum_ = l + 1L;
            logger.trace((Object)("next set retrieved  minimum_=" + this.minimum_ + "  maximum=" + this.maximum_));
        }
        catch (SQLException sQLException) {
            throw ExceptionPropagator.wrap((Throwable)sQLException);
        }
    }
}

