/*
 * Decompiled with CFR 0.152.
 */
package net.model3.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import net.model3.hibernate.HibernateSession;
import net.model3.hibernate.UidGenerator;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.DateX;
import net.sf.hibernate.CallbackException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Lifecycle;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.Validatable;
import net.sf.hibernate.ValidationFailure;

public abstract class PersistentObject
implements Lifecycle,
Validatable,
Serializable {
    private static final Logger logger = LoggerHelper.getLogger();
    private boolean unsaved_ = true;
    private Long uid_;

    public abstract DateX getLastChangeTimestamp();

    protected abstract void setLastChangeTimestamp(DateX var1);

    public abstract DateX getCreationTimestamp();

    protected abstract void setCreationTimestamp(DateX var1);

    public String toString() {
        return this.getQualifiedKeyName();
    }

    public int compareTo(Object object) {
        if (!(object instanceof PersistentObject)) {
            throw new ClassCastException(object.getClass().getName() + " to " + PersistentObject.class.getName());
        }
        PersistentObject persistentObject = (PersistentObject)object;
        return persistentObject.getUid().compareTo(this.getUid());
    }

    public boolean equals(Object object) {
        if (object instanceof Long) {
            return this.getUid().equals(object);
        }
        if (object instanceof PersistentObject) {
            PersistentObject persistentObject = (PersistentObject)object;
            return persistentObject.getUid().equals(this.getUid());
        }
        return false;
    }

    public int hashCode() {
        return this.getUid().hashCode();
    }

    public abstract Integer getVersion();

    public void persist() {
        try {
            logger.trace((Object)("persisting " + this));
            HibernateSession.currentSession().saveOrUpdate((Object)this);
        }
        catch (HibernateException hibernateException) {
            logger.error((Object)"", (Object)hibernateException);
        }
    }

    public void delete() {
        try {
            if (!this.isUnsaved()) {
                logger.trace((Object)("deleting " + this));
                HibernateSession.currentSession().delete((Object)this);
            }
        }
        catch (HibernateException hibernateException) {
            logger.error((Object)"delete()", (Object)hibernateException);
        }
    }

    public void refresh() {
        try {
            Session session = HibernateSession.currentSession();
            if (!session.contains((Object)this)) {
                HibernateSession.currentSession().load((Object)this, (Serializable)this.getUid());
            }
        }
        catch (Exception exception) {
            logger.error((Object)"error occurred while trying to refresh() rethrowing", (Object)exception);
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void lock() throws HibernateException, SQLException {
        HibernateSession.currentSession().lock((Object)this, LockMode.UPGRADE);
    }

    public void checkVersion(int n) throws StaleObjectStateException {
        if (n != this.getVersion()) {
            throw new StaleObjectStateException(this.getClass(), (Serializable)this.getUid());
        }
    }

    public boolean onSave(Session session) throws CallbackException {
        this.setCreationTimestamp(new DateX());
        this.setLastChangeTimestamp(new DateX());
        return false;
    }

    public boolean onDelete(Session session) throws CallbackException {
        return false;
    }

    public boolean onUpdate(Session session) throws CallbackException {
        return false;
    }

    public void onLoad(Session session, Serializable serializable) {
        this.unsaved_ = false;
    }

    public void validate() throws ValidationFailure {
    }

    void setUnsaved(boolean bl) {
        this.unsaved_ = bl;
    }

    public boolean isUnsaved() {
        return this.unsaved_;
    }

    public boolean isSaved() {
        return !this.unsaved_;
    }

    public String getQualifiedKeyName() {
        return this.getClass().getName() + "@uid=" + this.getUid();
    }

    protected abstract Map getPersistentAttributes();

    protected abstract String getPersistentAttribute(String var1);

    protected abstract void setPersistentAttribute(String var1, String var2);

    public Long getUid() {
        if (this.uid_ == null) {
            this.uid_ = UidGenerator.getInstance().next();
            logger.trace((Object)("uid of " + this.uid_ + " generated for " + this));
        }
        return this.uid_;
    }

    private void setUid(Long l) {
        if (this.uid_ != null && !this.uid_.equals(l)) {
            throw new RuntimeException("cannot set uid to " + l + " uid already set as " + this.uid_);
        }
        this.uid_ = l;
    }
}

