/*
 * Decompiled with CFR 0.152.
 */
package net.model3.hibernate;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.model3.hibernate.HibernateSession;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class HibernateFilter
implements Filter {
    private static final Logger logger = LoggerHelper.getLogger();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        logger.trace((Object)"hibernate filter started");
        if (HibernateSession.hasActiveSession()) {
            logger.error((Object)("hibernate session still open " + HibernateSession.currentSession() + " will close it now"));
            HibernateSession.closeSession();
        }
        boolean bl = false;
        try {
            filterChain.doFilter(servletRequest, servletResponse);
            bl = true;
            return;
        }
        catch (ServletException servletException) {
            throw ExceptionPropagator.wrap((Throwable)servletException);
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap((Throwable)iOException);
        }
        finally {
            if (HibernateSession.hasActiveSession()) {
                try {
                    if (bl) {
                        HibernateSession.commitCurrentSession();
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)"unable to commit session", (Object)exception);
                }
                finally {
                    try {
                        HibernateSession.closeSession();
                    }
                    catch (Exception exception) {
                        logger.error((Object)"unable to close session (swallowing exception)", (Object)exception);
                    }
                }
            }
            logger.trace((Object)"hibernate filter ended");
        }
    }
}

