/*
 * Decompiled with CFR 0.152.
 */
package net.model3.hibernate;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;

public class DBCPConnectionProvider
implements ConnectionProvider {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final String PREFIX = "hibernate.dbcp.";
    private BasicDataSource ds;
    private static final String DBCP_PS_MAXACTIVE = "hibernate.dbcp.ps.maxActive";
    private static final String AUTOCOMMIT = "hibernate.connection.autocommit";

    public void configure(Properties properties) throws HibernateException {
        try {
            String string;
            String string2;
            Object object;
            Object object2;
            Properties properties2;
            String string3;
            logger.debug((Object)"Configure DBCPConnectionProvider");
            Properties properties3 = new Properties();
            String string4 = properties.getProperty("hibernate.connection.driver_class");
            String string5 = properties.getProperty("hibernate.connection.url");
            properties3.put("driverClassName", string4);
            properties3.put("url", string5);
            String string6 = properties.getProperty("hibernate.connection.username");
            String string7 = properties.getProperty("hibernate.connection.password");
            properties3.put("username", string6);
            properties3.put("password", string7);
            String string8 = properties.getProperty("hibernate.connection.isolation");
            if (string8 != null && string8.trim().length() > 0) {
                properties3.put("defaultTransactionIsolation", string8);
            }
            if ((string3 = properties.getProperty(AUTOCOMMIT)) != null && string3.trim().length() > 0) {
                properties3.put("defaultAutoCommit", string3);
            } else {
                properties3.put("defaultAutoCommit", String.valueOf(Boolean.FALSE));
            }
            String string9 = properties.getProperty("hibernate.connection.pool_size");
            if (string9 != null && string9.trim().length() > 0 && Integer.parseInt(string9) > 0) {
                properties3.put("maxActive", string9);
            }
            if ((properties2 = ConnectionProviderFactory.getConnectionProperties((Properties)properties)).size() > 0) {
                object2 = new StringBuffer();
                object = properties2.keySet().iterator();
                while (object.hasNext()) {
                    string2 = (String)object.next();
                    string = properties2.getProperty(string2);
                    ((StringBuffer)object2).append(string2).append('=').append(string);
                    if (!object.hasNext()) continue;
                    ((StringBuffer)object2).append(';');
                }
                properties3.put("connectionProperties", ((StringBuffer)object2).toString());
            }
            object2 = properties.keySet().iterator();
            while (object2.hasNext()) {
                object = String.valueOf(object2.next());
                if (!((String)object).startsWith(PREFIX)) continue;
                string2 = ((String)object).substring(PREFIX.length());
                string = properties.getProperty((String)object);
                properties3.put(string2, string);
            }
            if (properties.getProperty(DBCP_PS_MAXACTIVE) != null) {
                properties3.put("poolPreparedStatements", String.valueOf(Boolean.TRUE));
                properties3.put("maxOpenPreparedStatements", properties.getProperty(DBCP_PS_MAXACTIVE));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Creating a DBCP BasicDataSource with the following DBCP factory properties:");
                object2 = new StringWriter();
                properties3.list(new PrintWriter((Writer)object2, true));
                logger.debug((Object)((StringWriter)object2).toString());
            }
            this.ds = (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)properties3);
            object2 = this.ds.getConnection();
            object2.close();
            this.logStatistics();
        }
        catch (Exception exception) {
            String string = "Could not create a DBCP pool";
            logger.fatal((Object)string, (Object)exception);
            if (this.ds != null) {
                try {
                    this.ds.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.ds = null;
            }
            throw new HibernateException(string, (Throwable)exception);
        }
        logger.debug((Object)"Configure DBCPConnectionProvider complete");
    }

    public Connection getConnection() throws SQLException {
        Connection connection = null;
        try {
            connection = this.ds.getConnection();
        }
        finally {
            this.logStatistics();
        }
        return connection;
    }

    public void closeConnection(Connection connection) throws SQLException {
        try {
            connection.close();
        }
        finally {
            this.logStatistics();
        }
    }

    public void close() throws HibernateException {
        logger.debug((Object)"Close DBCPConnectionProvider");
        this.logStatistics();
        try {
            if (this.ds != null) {
                this.ds.close();
                this.ds = null;
            } else {
                logger.warn((Object)"Cannot close DBCP pool (not initialized)");
            }
        }
        catch (Exception exception) {
            throw new HibernateException("Could not close DBCP pool", (Throwable)exception);
        }
        logger.debug((Object)"Close DBCPConnectionProvider complete");
    }

    protected void logStatistics() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("active: " + this.ds.getNumActive() + " (max: " + this.ds.getMaxActive() + ")   idle: " + this.ds.getNumIdle() + "(max: " + this.ds.getMaxIdle() + ")"));
        }
    }
}

