/*
 * Decompiled with CFR 0.152.
 */
package net.model3.file;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.model3.file.FileX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class TimestampedFilenameHelper {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final String FILESYSTEM_COMPATIBLE_DATE_FORMAT = "yyyy-MM-dd-EEE_HH-mm-ss";
    private static final Pattern FILESYSTEM_COMPATIBLE_DATE_FORMAT_PATTERN = Pattern.compile("20\\d\\d-[0|1]\\d-[0-3]\\d-\\w\\w\\w_[0-2]\\d-[0-5]\\d-[0-5]\\d");

    public static String getFileSystemCompatibleTimestamp() {
        return TimestampedFilenameHelper.getFileSystemCompatibleTimestamp(new Date());
    }

    public static String getFileSystemCompatibleTimestamp(Date date) {
        return new SimpleDateFormat(FILESYSTEM_COMPATIBLE_DATE_FORMAT).format(date);
    }

    public static Date getTimestamp(String string) {
        Matcher matcher = FILESYSTEM_COMPATIBLE_DATE_FORMAT_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group();
            try {
                return new SimpleDateFormat(FILESYSTEM_COMPATIBLE_DATE_FORMAT).parse(string2);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public static void purgeTimestampedFiles(FileX fileX, boolean bl, TimeDuration timeDuration) {
        Date date = new Date(System.currentTimeMillis() - timeDuration.inMilliseconds());
        Iterator<FileX> iterator = fileX.iterator(bl, false, null);
        while (iterator.hasNext()) {
            FileX fileX2 = iterator.next();
            Date date2 = TimestampedFilenameHelper.getTimestamp(fileX2.getName());
            if (date2 == null || !date2.before(date)) continue;
            try {
                fileX2.delete();
                logger.debug((Object)("purged " + fileX2.getCanonicalPath()));
            }
            catch (Exception exception) {
                logger.debug((Object)("unable to purge " + fileX2.getCanonicalPath()), (Object)exception);
            }
        }
    }
}

