/*
 * Decompiled with CFR 0.152.
 */
package net.model3.file;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.model3.file.FileX;
import net.model3.newfile.Directory;
import net.model3.newfile.Path;
import net.model3.newfile.selector.AndSelector;
import net.model3.newfile.selector.FileFilterSelector;
import net.model3.newfile.selector.NameSelector;
import net.model3.newfile.selector.OrSelector;
import net.model3.newfile.selector.Selector;
import net.model3.newfile.selector.SelectorHelper;

public class FileXIterator {
    private boolean includeDirectoriesInIterator_ = false;
    private boolean recurseIntoExcludedDirectories_ = true;
    private boolean recurse_ = true;
    private boolean useDefaultExcludes_ = true;
    private List<String> includePatterns_ = new ArrayList<String>();
    private FileFilter fileFilter_;
    private Directory root_;
    private Selector selector_;

    public FileFilter getFileFilter() {
        return this.fileFilter_;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter_ = fileFilter;
    }

    public boolean getIncludeDirectoriesInIterator() {
        return this.includeDirectoriesInIterator_;
    }

    public void setIncludeDirectoriesInIterator(boolean bl) {
        this.includeDirectoriesInIterator_ = bl;
    }

    public boolean getRecurse() {
        return this.recurse_;
    }

    public void setRecurse(boolean bl) {
        this.recurse_ = bl;
    }

    public boolean getRecurseIntoExcludedDirectories() {
        return this.recurseIntoExcludedDirectories_;
    }

    public void setRecurseIntoExcludedDirectories(boolean bl) {
        this.recurseIntoExcludedDirectories_ = bl;
    }

    public Directory getRoot() {
        return this.root_;
    }

    public void setRoot(Directory directory) {
        this.root_ = directory;
    }

    public boolean getUseDefaultExcludes() {
        return this.useDefaultExcludes_;
    }

    public void setUseDefaultExcludes(boolean bl) {
        this.useDefaultExcludes_ = bl;
    }

    public Iterator<FileX> iterator() {
        return this.list().iterator();
    }

    public List<FileX> list() {
        ArrayList<FileX> arrayList = new ArrayList<FileX>();
        if (this.root_ == null) {
            throw new NullPointerException("root must be set");
        }
        this.initSelector();
        this.loadFileList(arrayList, this.root_);
        return arrayList;
    }

    private void initSelector() {
        AndSelector andSelector = new AndSelector();
        if (this.useDefaultExcludes_) {
            andSelector.add(SelectorHelper.DEFAULT_EXCLUDES);
        }
        if (this.includePatterns_.size() > 0) {
            OrSelector orSelector = new OrSelector();
            for (String string : this.includePatterns_) {
                NameSelector nameSelector = new NameSelector(string);
                orSelector.add((Selector)nameSelector);
            }
            andSelector.add((Selector)orSelector);
        }
        if (this.fileFilter_ != null) {
            andSelector.add((Selector)new FileFilterSelector(this.fileFilter_));
        }
        this.selector_ = andSelector;
    }

    private void loadFileList(List<FileX> list, Directory directory) {
        if (!directory.exists()) {
            throw new RuntimeException(directory.getCanonicalPath() + " does not exist");
        }
        File[] fileArray = directory.asFile().listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            boolean bl = file.isDirectory();
            Object object = bl ? new Directory(file) : new net.model3.newfile.File(file);
            boolean bl2 = this.selector_.isSelected(this.root_, (Path)object);
            if (bl && this.recurse_ && (this.recurseIntoExcludedDirectories_ || bl2)) {
                this.loadFileList(list, (Directory)object);
            }
            if (!bl2 || bl && !this.includeDirectoriesInIterator_) continue;
            list.add(new FileX(file));
        }
    }

    public void addIncludePatterns(String string) {
        for (String string2 : string.split(";")) {
            this.includePatterns_.add(string2);
        }
    }

    public static void main(String[] stringArray) {
        FileXIterator fileXIterator = new FileXIterator();
        fileXIterator.setRoot(new Directory("c:/code/birthprint/images/"));
        fileXIterator.addIncludePatterns("*.png");
        for (FileX fileX : fileXIterator.list()) {
            System.out.println(fileX.getCanonicalPath());
        }
    }
}

