/*
 * Decompiled with CFR 0.152.
 */
package net.model3.file;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.model3.file.FileFilterX;
import net.model3.file.FileXIterator;
import net.model3.io.StreamHelper;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.newfile.Directory;

public class FileX
extends File {
    private static final char PATH_SLASH;
    private static final char PATH_SLASH_ALT;
    private static final Logger logger;

    private static boolean isCrossPlatformNormalizationNeeded() {
        return PATH_SLASH != PATH_SLASH_ALT;
    }

    public FileX(File file, String string) {
        super(file, string);
    }

    public FileX(URI uRI) {
        super(uRI);
    }

    public FileX(File file) {
        this(file.getPath());
    }

    public FileX(String string) {
        super(string);
    }

    public FileX(URL uRL) {
        this(UrlX.toURI((URL)uRL));
    }

    public FileX(String string, String string2) {
        super(string, string2);
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File("c:/a/birthprint.jar");
        FileX fileX = new FileX("c:/a/birthprint.jar");
        System.out.println(file.mkdirs());
        System.out.println(fileX.mkdirs());
        System.out.println(FileX.getFilenameOnly("test1.text"));
        System.out.println(FileX.getFilenameOnly("asdf/ewreqw\\test2.text"));
        System.out.println(FileX.getFilenameOnly("asdf/test3.text"));
        System.out.println(FileX.getFilenameOnly("asdf\\test4.text"));
        FileX.print(new FileX("."));
        FileX.print(new FileX("test.txt"));
        FileX.print(new FileX("d:/4nt/"));
        FileX.print(new FileX("\\prj/java/"));
        FileX.print(new FileX("../net/"));
    }

    public BufferedReader createReader() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this));
            return bufferedReader;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public FileInputStream createInputStream() {
        try {
            if (!this.exists()) {
                throw new FileNotFoundException(this.getCanonicalPath());
            }
            FileInputStream fileInputStream = new FileInputStream(this);
            return fileInputStream;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public FileOutputStream createOutputStream(boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this, bl);
            return fileOutputStream;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public PrintStream createPrintStream() {
        return this.createPrintStream(false);
    }

    public PrintStream createPrintStream(boolean bl) {
        return new PrintStream(this.createOutputStream(bl));
    }

    public static void print(File file) throws Exception {
        System.out.println(" getPath()=" + file.getPath());
        System.out.println(" getCanonicalPath()=" + file.getCanonicalPath());
        System.out.println(" getAbsolutePath()=" + file.getAbsolutePath());
        System.out.println(" getName()=" + file.getName());
    }

    public static String getFilenameOnly(String string) {
        int n;
        int n2 = string.lastIndexOf(92);
        int n3 = n2 > (n = string.lastIndexOf(47)) ? n2 : n;
        if (n3 > 0 && n3 != string.length()) {
            return string.substring(n3 + 1);
        }
        return string;
    }

    public void copyFileTo(FileX fileX) {
        this.copyFileTo(fileX, false);
    }

    public void copyFileTo(FileX fileX, boolean bl) {
        logger.trace((Object)("copying " + this.getCanonicalPath() + " to " + fileX.getCanonicalPath()));
        try {
            int n;
            Object object;
            Object object2;
            fileX.getParentFileX().makeDirectories();
            FileInputStream fileInputStream = new FileInputStream(this);
            if (fileX.exists()) {
                fileX.delete();
            }
            if (bl) {
                object2 = new ZipOutputStream(new FileOutputStream(fileX));
                ((ZipOutputStream)object2).setLevel(9);
                ((ZipOutputStream)object2).setMethod(8);
                ((ZipOutputStream)object2).putNextEntry(new ZipEntry(this.getName()));
                object = object2;
            } else {
                object = new FileOutputStream(fileX);
            }
            object2 = new byte[100000];
            while ((n = ((InputStream)fileInputStream).read((byte[])object2)) >= 0) {
                ((OutputStream)object).write((byte[])object2, 0, n);
                if (((Object)object2).length == n) continue;
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap((Throwable)iOException);
        }
    }

    public String getBaseFilename() {
        int n;
        String string = this.getCanonicalPath();
        int n2 = string.lastIndexOf(46);
        int n3 = string.lastIndexOf(92);
        int n4 = Math.max(n3, n = string.lastIndexOf(47));
        n4 = n4 < 0 ? 0 : ++n4;
        if (n2 > 0) {
            return string.substring(n4, n2);
        }
        return "";
    }

    @Override
    public String getCanonicalPath() {
        try {
            String string = super.getCanonicalPath();
            return string;
        }
        catch (IOException iOException) {
            String string = "error in getCanonicalPath() for " + this.getPath();
            logger.error((Object)string, (Object)iOException);
            throw ExceptionPropagator.wrap((String)string, (Throwable)iOException);
        }
    }

    public String getCrossPlatformCanonicalPath() {
        return FileX.makePathCrossPlatform(this.getCanonicalPath());
    }

    public String getCrossPlatformPath() {
        return FileX.makePathCrossPlatform(this.getPath());
    }

    public String getCrossPlatformPathRelativeTo(FileX fileX) {
        return FileX.makePathCrossPlatform(this.getPathRelativeTo(fileX));
    }

    @Override
    public File getCanonicalFile() {
        return this.getCanonicalFileX();
    }

    public FileX getCanonicalFileX() {
        try {
            File file = super.getCanonicalFile();
            if (file instanceof FileX) {
                return (FileX)file;
            }
            return new FileX(file);
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap((String)"error get canonical file", (Throwable)iOException);
        }
    }

    public String getExtension() {
        String string = this.getCanonicalPath();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    public String getPathRelativeTo(FileX fileX) {
        String string = fileX.getCanonicalPath();
        String string2 = this.getCanonicalPath();
        if (string2.equals(string)) {
            return "";
        }
        if (string2.startsWith(string)) {
            String string3 = string2.substring(string.length() + 1);
            return string3;
        }
        throw new RuntimeException("file " + string2 + " not in path " + string);
    }

    public Iterator<FileX> iterator(String string) {
        return this.iterator(string, true);
    }

    public Iterator<FileX> iterator(String string, boolean bl) {
        FileXIterator fileXIterator = new FileXIterator();
        fileXIterator.setRoot(new Directory((File)this));
        fileXIterator.addIncludePatterns(string);
        fileXIterator.setUseDefaultExcludes(bl);
        return fileXIterator.iterator();
    }

    public Iterator<FileX> iterator() {
        return this.iterator(true, false, FileFilterX.ACCEPT_ALL);
    }

    public Iterator<FileX> iterator(boolean bl, FileFilter fileFilter) {
        return this.iterator(bl, false, fileFilter);
    }

    public Iterator<FileX> iteratorWithRealRecurseFalseOption(boolean bl, boolean bl2, FileFilter fileFilter) {
        FileXIterator fileXIterator = new FileXIterator();
        fileXIterator.setRoot(new Directory((File)this));
        fileXIterator.setFileFilter(fileFilter);
        fileXIterator.setIncludeDirectoriesInIterator(bl2);
        fileXIterator.setRecurse(bl);
        return fileXIterator.iterator();
    }

    public Iterator<FileX> iterator(boolean bl, boolean bl2, FileFilter fileFilter) {
        FileXIterator fileXIterator = new FileXIterator();
        fileXIterator.setRoot(new Directory((File)this));
        fileXIterator.setFileFilter(fileFilter);
        fileXIterator.setIncludeDirectoriesInIterator(bl2);
        return fileXIterator.iterator();
    }

    public FileX[] listFilesX() {
        return (FileX[])this.listFiles();
    }

    @Override
    public File[] listFiles() {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        File[] fileArray = new FileX[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new FileX(this.getPath(), stringArray[i]);
        }
        return fileArray;
    }

    @Override
    public File[] listFiles(FileFilter fileFilter) {
        FileX[] fileXArray = this.listFilesX();
        if (fileXArray == null) {
            return null;
        }
        ArrayList<FileX> arrayList = new ArrayList<FileX>();
        for (int i = 0; i < fileXArray.length; ++i) {
            if (fileFilter != null && !fileFilter.accept(fileXArray[i])) continue;
            arrayList.add(fileXArray[i]);
        }
        return arrayList.toArray(new FileX[arrayList.size()]);
    }

    @Override
    public File getParentFile() {
        String string = this.getParent();
        if (string == null) {
            if (this.isAbsolute()) {
                return null;
            }
            FileX fileX = this.getCanonicalFileX().getParentFileX();
            return fileX;
        }
        return new FileX(string);
    }

    public boolean startsWith(FileX fileX) {
        return StringX.startsWith((String)this.getCanonicalPath(), (String)fileX.getCanonicalPath(), (boolean)false);
    }

    public FileReader createFileReader() {
        try {
            return new FileReader(this);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public FileOutputStream createOutputStream() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this);
            return fileOutputStream;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void makeDirectories() {
        this.makeDirectories(true);
    }

    public void makeDirectory() {
        this.mkdir();
    }

    public FileX getParentFileX() {
        return (FileX)this.getParentFile();
    }

    @Override
    public boolean mkdir() {
        return this.makeDirectories(false);
    }

    @Override
    public boolean mkdirs() {
        return this.makeDirectories(true);
    }

    private boolean makeDirectories(boolean bl) {
        boolean bl2;
        if (this.exists()) {
            if (this.isDirectory()) {
                return false;
            }
            throw new RuntimeException("unable to create directory path already exists as a file " + this.getCanonicalPath());
        }
        if (bl) {
            this.getParentFileX().makeDirectories(true);
        }
        if (!(bl2 = super.mkdir()) && !this.exists()) {
            throw new RuntimeException("mkdir() returned false when trying to make directory for " + this.getCanonicalPath());
        }
        return bl2;
    }

    public boolean renameTo(FileX fileX) {
        if (fileX.exists()) {
            throw new RuntimeException("unable to rename " + this.getCanonicalPath() + " to " + fileX.getCanonicalPath() + " to file already exists.");
        }
        boolean bl = super.renameTo(fileX);
        if (!bl) {
            bl = super.renameTo(fileX);
            throw new RuntimeException("unable to rename " + this.getCanonicalPath() + " to " + fileX.getCanonicalPath());
        }
        logger.trace((Object)("renamed " + this.getCanonicalPath() + " to " + fileX.getCanonicalPath()));
        return bl;
    }

    public boolean sameDrive(FileX fileX) {
        String string = fileX.getCanonicalPath().substring(0, 2);
        String string2 = this.getCanonicalPath().substring(0, 2);
        return string.equalsIgnoreCase(string2);
    }

    public void moveTo(FileX fileX) {
        if (!this.sameDrive(fileX)) {
            throw new RuntimeException("copy and delete moves not supported yet");
        }
        this.renameTo(fileX);
    }

    @Override
    public boolean delete() {
        logger.trace((Object)("deleting " + this.getCanonicalPath()));
        boolean bl = super.delete();
        if (this.exists() && !bl) {
            throw new RuntimeException("unable to delete " + this.getCanonicalPath());
        }
        return true;
    }

    public void deleteTree() {
        this.deleteTree(true);
    }

    public void deleteTree(boolean bl) {
        RuntimeException runtimeException;
        block12: {
            Object object;
            if (!this.exists()) {
                return;
            }
            if (!this.isDirectory()) {
                throw new RuntimeException("can only call deleteTree() on a directory");
            }
            runtimeException = null;
            logger.trace((Object)("deleting tree at " + this.getCanonicalPath()));
            Iterator<FileX> iterator = this.iterator(true, false, null);
            while (iterator.hasNext()) {
                object = iterator.next();
                try {
                    ((FileX)object).delete();
                }
                catch (RuntimeException runtimeException2) {
                    if (runtimeException == null) continue;
                    runtimeException = runtimeException2;
                }
            }
            object = this.iterator(true, true, null);
            while (object.hasNext()) {
                FileX fileX = (FileX)object.next();
                if (!fileX.isDirectory()) continue;
                try {
                    fileX.delete();
                }
                catch (RuntimeException runtimeException3) {
                    if (runtimeException == null) continue;
                    runtimeException = runtimeException3;
                }
            }
            if (bl) {
                try {
                    this.delete();
                }
                catch (RuntimeException runtimeException4) {
                    if (runtimeException == null) break block12;
                    runtimeException = runtimeException4;
                }
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public FileX createSubpath(String string) {
        return new FileX(this, string);
    }

    public List<String> readLines() {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap((Throwable)iOException);
        }
    }

    public boolean isRelativeTo(FileX fileX) {
        return this.getCanonicalPath().startsWith(fileX.getCanonicalPath());
    }

    public byte[] readBytes() {
        if (!this.exists()) {
            throw new RuntimeException(this.getCanonicalPath() + " file not found.");
        }
        byte[] byArray = new byte[(int)this.length()];
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap((Throwable)iOException);
        }
        return byArray;
    }

    public String readText() {
        return new String(this.readBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLines(String[] stringArray) {
        try (PrintStream printStream = this.createPrintStream();){
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                printStream.println(string);
            }
        }
    }

    public void write(byte[] byArray) {
        this.write(byArray, false);
    }

    public void writeLine(String string) {
        this.writeLine(string, false);
    }

    public void writeLine(String string, boolean bl) {
        this.write((string + "\n").getBytes(), bl);
    }

    public void write(String string, boolean bl) {
        this.write(string.getBytes(), bl);
    }

    public void write(String string) {
        this.write(string, false);
    }

    public void writeObject(Object object) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.createOutputStream());
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap((Throwable)iOException);
        }
    }

    public Object readObject() {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(this.createInputStream());
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            StreamHelper.forcedClose(objectInputStream);
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void write(Collection<String> collection, boolean bl) {
        String string = "";
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next() + "\n";
        }
        this.write(string, bl);
    }

    public void write(byte[] byArray, boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this, bl);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap((Throwable)iOException);
        }
    }

    @Override
    public URL toURL() {
        try {
            return super.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw ExceptionPropagator.wrap((Throwable)malformedURLException);
        }
    }

    public static String makePathCrossPlatform(String string) {
        if (FileX.isCrossPlatformNormalizationNeeded()) {
            string = string.replace(PATH_SLASH, PATH_SLASH_ALT);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nioCopy(FileX fileX) {
        FileX fileX2 = this;
        try {
            if (!fileX.exists()) {
                fileX.createNewFile();
            }
            FileChannel fileChannel = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            try {
                fileChannel = new FileInputStream(fileX2).getChannel();
                abstractInterruptibleChannel = new FileOutputStream(fileX).getChannel();
                ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
            }
            finally {
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
            }
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap((Throwable)iOException);
        }
    }

    public static String getFileSystemCompatibleTimestamp() {
        return FileX.getFileSystemCompatibleTimestamp(new Date());
    }

    public static String getFileSystemCompatibleTimestamp(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd-EEE_HH-mm-ss").format(date);
    }

    public Directory asDirectory() {
        return new Directory((File)this);
    }

    static {
        logger = LoggerHelper.getLogger(FileX.class);
        String string = System.getProperty("file.separator");
        if (string == null) {
            throw new RuntimeException("file.separator system property not found");
        }
        PATH_SLASH = string.charAt(0);
        PATH_SLASH_ALT = (char)47;
    }
}

