/*
 * Decompiled with CFR 0.152.
 */
package net.model3.cfgcfg;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.model3.cfgcfg.BigDecimalProperty;
import net.model3.cfgcfg.BooleanProperty;
import net.model3.cfgcfg.CalculationType;
import net.model3.cfgcfg.ConfigMetadata;
import net.model3.cfgcfg.DirProperty;
import net.model3.cfgcfg.FileProperty;
import net.model3.cfgcfg.FontType;
import net.model3.cfgcfg.IntProperty;
import net.model3.cfgcfg.PercentageType;
import net.model3.cfgcfg.StringProperty;
import net.model3.cfgcfg.TimeDurationProperty;
import net.model3.collections.PropertiesX;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public abstract class PropertyMetadata
implements Cloneable {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final Map typeNameMap_ = new HashMap();
    private static final Map instanceTypes_ = new HashMap();
    private static final Map primitiveTypes_ = new HashMap();
    private ConfigMetadata configMetadata_;
    private String javaName_;
    private String propertyName_;
    private String description_;
    private boolean required_ = true;
    private boolean requiredOnDemand_ = false;
    private String default_;
    private String initSourceCode_;
    private String name_;
    private Class returnType_;
    private String returnTypeJavaName_;
    private Class objectType_;
    private String objectTypeJavaName_;

    public static PropertyMetadata instantiate(String string) {
        PropertyMetadata propertyMetadata = (PropertyMetadata)typeNameMap_.get(string.toLowerCase());
        if (propertyMetadata == null) {
            throw new RuntimeException("property type '" + string + "' not found.");
        }
        try {
            return (PropertyMetadata)propertyMetadata.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw ExceptionPropagator.wrap((Throwable)cloneNotSupportedException);
        }
    }

    private static void addType(PropertyMetadata propertyMetadata) {
        typeNameMap_.put(propertyMetadata.getTypeName().toLowerCase(), propertyMetadata);
    }

    protected PropertyMetadata() {
    }

    protected PropertyMetadata(Class clazz) {
        this.setReturnType(clazz);
        this.setObjectType(clazz);
    }

    protected PropertyMetadata(Class clazz, Class clazz2) {
        this.setReturnType(clazz2);
        this.setObjectType(clazz);
    }

    public String getInitSourceCode() {
        return this.initSourceCode_;
    }

    public void setInitSourceCode(String string) {
        this.initSourceCode_ = string;
    }

    public void setDefault(String string) {
        this.default_ = string;
        this.required_ = false;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String string) {
        this.description_ = string;
    }

    public ConfigMetadata getConfigMetadata() {
        return this.configMetadata_;
    }

    void setConfigMetadata(ConfigMetadata configMetadata) {
        this.configMetadata_ = configMetadata;
    }

    public boolean isRequired() {
        return this.required_;
    }

    public void setRequired(boolean bl) {
        this.required_ = bl;
    }

    public void setJavaName(String string) {
        this.javaName_ = Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public Object getValue(String string) {
        Object object = null;
        if (string == null) {
            string = PropertiesX.processStringForVariables((Properties)System.getProperties(), (String)this.default_, (boolean)true);
        }
        object = this.parseImpl(string);
        this.validate(object);
        return object;
    }

    public String getPropertyName() {
        return this.propertyName_;
    }

    public void setPropertyName(String string) {
        this.propertyName_ = string;
    }

    public void loadedFromXml() {
        if (this.returnType_ == null) {
            throw new RuntimeException("must specify a returnType");
        }
        if (this.objectType_ == null) {
            throw new RuntimeException("must specify an objectType");
        }
        this.name_ = this.javaName_ == null ? this.propertyName_ : this.javaName_;
        if (this.javaName_ == null && this.propertyName_ != null) {
            this.setJavaName(this.convertPropNameToJavaName(this.propertyName_));
        }
        if (this.javaName_ == null && this.propertyName_ == null) {
            throw new RuntimeException("must specify <propName> attribute");
        }
    }

    public void setPropName(String string) {
        this.setPropertyName(string);
    }

    public void validate(Object object) {
        if (object == null && (this.isRequired() || this.isRequiredOnDemand())) {
            throw new RuntimeException("required property " + this.getPropertyName() + " not found.");
        }
    }

    public void validate(String string) {
        this.validate(this.parseImpl(string));
    }

    public abstract String getTypeName();

    public abstract Object parseImpl(String var1);

    public Class getReturnType() {
        return this.returnType_;
    }

    public String getReturnTypeJavaName() {
        return this.returnTypeJavaName_;
    }

    public String getObjectTypeJavaName() {
        if (this.objectTypeJavaName_ == null) {
            "tihs".toString();
        }
        return this.objectTypeJavaName_;
    }

    public boolean isRequiredOnDemand() {
        return this.requiredOnDemand_;
    }

    public void setRequiredOnDemand(boolean bl) {
        this.requiredOnDemand_ = bl;
    }

    void validateMetadata() {
    }

    String getJavaName() {
        return this.javaName_;
    }

    protected String convertPropNameToJavaName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                bl = false;
                c = Character.toUpperCase(c);
            }
            if (c == '.' || c == '-' || c == '_') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String getInitializationCode() {
        if (this.initSourceCode_ == null) {
            return this.getDefaultInitializationCode();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("default_init_code", this.getDefaultInitializationCode());
        try {
            return PropertiesX.processStringForVariables(hashMap, (String)this.initSourceCode_, (boolean)true);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return this.getDefaultInitializationCode();
        }
    }

    public String getDefaultInitializationCode() {
        return "(" + this.getObjectType().getName() + ") getPropertyAsObject( \"" + this.getPropertyName() + "\" )";
    }

    public String toString() {
        return this.getClass().getName() + "[javaname=" + this.javaName_ + ", propname=" + this.propertyName_ + "]";
    }

    public Class getObjectType() {
        return this.objectType_;
    }

    public void setObjectType(String string) {
        try {
            this.setObjectType(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ExceptionPropagator.wrap((Throwable)classNotFoundException);
        }
    }

    public void setReturnType(String string) {
        Class clazz = (Class)primitiveTypes_.get(string.toLowerCase());
        if (clazz != null) {
            this.setReturnType(clazz);
        } else {
            try {
                this.setReturnType(Class.forName(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ExceptionPropagator.wrap((Throwable)classNotFoundException);
            }
        }
    }

    public void setObjectType(Class clazz) {
        this.objectType_ = clazz;
        this.objectTypeJavaName_ = this.getJavaName(clazz);
    }

    public void setReturnType(Class clazz) {
        this.returnType_ = clazz;
        this.returnTypeJavaName_ = this.getJavaName(clazz);
    }

    private String getJavaName(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType().getName() + "[]";
        }
        if (clazz.getName().startsWith("java.lang.")) {
            return clazz.getName().substring("java.lang.".length());
        }
        return clazz.getName();
    }

    public Class getPrimitiveType(String string) {
        return (Class)primitiveTypes_.get(string.toLowerCase());
    }

    public Class getInstanceType(Class clazz) {
        return (Class)instanceTypes_.get(clazz.getName());
    }

    static {
        PropertyMetadata.addType(new IntProperty(true));
        PropertyMetadata.addType(new IntProperty(false));
        PropertyMetadata.addType(new BigDecimalProperty());
        PropertyMetadata.addType(new BooleanProperty(true));
        PropertyMetadata.addType(new BooleanProperty(false));
        PropertyMetadata.addType(new StringProperty());
        PropertyMetadata.addType(new DirProperty());
        PropertyMetadata.addType(new FileProperty());
        PropertyMetadata.addType(new TimeDurationProperty());
        PropertyMetadata.addType(new CalculationType());
        PropertyMetadata.addType(new FontType());
        PropertyMetadata.addType(new PercentageType());
        primitiveTypes_.put("int", Integer.TYPE);
        primitiveTypes_.put("float", Float.TYPE);
        primitiveTypes_.put("double", Double.TYPE);
        primitiveTypes_.put("boolean", Boolean.TYPE);
        primitiveTypes_.put("byte", Byte.TYPE);
        primitiveTypes_.put("short", Short.TYPE);
        primitiveTypes_.put("char", Character.TYPE);
        primitiveTypes_.put("long", Long.TYPE);
        instanceTypes_.put("int", Integer.class);
        instanceTypes_.put("float", Float.class);
        instanceTypes_.put("double", Double.class);
        instanceTypes_.put("boolean", Boolean.class);
        instanceTypes_.put("byte", Byte.class);
        instanceTypes_.put("short", Short.class);
        instanceTypes_.put("char", Character.class);
        instanceTypes_.put("long", Long.class);
    }
}

