/*
 * Decompiled with CFR 0.152.
 */
package net.model3.cfgcfg;

import net.model3.cfgcfg.PropertyMetadata;
import net.model3.file.FileX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class DirProperty
extends PropertyMetadata {
    private static final Logger logger = LoggerHelper.getLogger();
    private boolean exists_ = false;
    private boolean createOnDemand_ = false;

    DirProperty() {
        super(FileX.class);
    }

    @Override
    public Object getValue(String string) {
        FileX fileX = (FileX)super.getValue(string);
        if (!fileX.exists() && this.createOnDemand_) {
            fileX.makeDirectories();
        }
        return fileX;
    }

    @Override
    public String getTypeName() {
        return "dir";
    }

    @Override
    public void validate(Object object) {
        FileX fileX = (FileX)object;
        if (fileX.exists() && !fileX.isDirectory()) {
            throw new RuntimeException("path exists but it is not a directory  " + fileX.getCanonicalPath());
        }
        if (this.exists_ && !this.createOnDemand_ && !fileX.exists()) {
            throw new RuntimeException("directory does not exist " + fileX.getCanonicalPath());
        }
    }

    @Override
    public Object parseImpl(String string) {
        FileX fileX = new FileX(string);
        return fileX;
    }

    public void setCreateOnDemand(boolean bl) {
        this.createOnDemand_ = bl;
    }

    public boolean isExists() {
        return this.exists_;
    }

    public void setExists(boolean bl) {
        this.exists_ = bl;
    }
}

