/*
 * Decompiled with CFR 0.152.
 */
package net.model3.cfgcfg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.model3.bean.ReflectionTool;
import net.model3.cfgcfg.ConfigMetadata;
import net.model3.cfgcfg.PropertyMetadata;
import net.model3.file.FileX;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.Tokenizer;
import org.apache.log4j.BasicConfigurator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class ConfigConfig {
    private static final Logger logger = LoggerHelper.getLogger();
    private ConfigMetadata configMetadata_ = new ConfigMetadata(this);
    private ReflectionTool beanTool_ = new ReflectionTool();
    private String xml_;
    private String staticClassname_;
    private String staticPackage_;
    private String implClassname_;
    private String implPackage_;
    private String additionalImplSourceCode_;
    private String instantiatedQualClassname_;

    public ConfigConfig(FileX fileX) {
        try {
            logger.debug((Object)("processing file " + fileX.getPath()));
            SAXReader sAXReader = new SAXReader();
            this.processDocument(sAXReader.read((File)fileX));
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public ConfigConfig(String string) {
        try {
            SAXReader sAXReader = new SAXReader();
            this.processDocument(sAXReader.read((Reader)new StringReader(string)));
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    private void processDocument(Document document) {
        this.xml_ = document.asXML();
        Element element = document.getRootElement();
        String string = element.selectSingleNode("/configconfig/codegen/static-class").getText();
        this.staticClassname_ = ClassX.getShortName((String)string);
        this.staticPackage_ = ClassX.getPackageName((String)string);
        Element element2 = (Element)element.selectSingleNode("/configconfig/additionalImplSourceCode");
        this.additionalImplSourceCode_ = element2 != null ? element2.getText() : "";
        Element element3 = element.element(new QName("/configconfig/codegen/impl-class"));
        if (element3 != null) {
            this.implClassname_ = element3.getText();
            this.implPackage_ = ClassX.getPackageName((String)string);
        } else {
            this.implClassname_ = this.staticClassname_ + "Impl";
            this.implPackage_ = this.staticPackage_;
        }
        Element element4 = element.element(new QName("/configconfig/codegen/instantiated-class"));
        this.instantiatedQualClassname_ = element4 != null ? element4.getText() : this.staticClassname_ + "Impl";
        Iterator iterator = element.elementIterator("property");
        while (iterator.hasNext()) {
            this.processProperty((Element)iterator.next());
        }
    }

    public void generateSource(FileX fileX) {
        try {
            this.generateImplClassSource(fileX);
            this.generateStaticClassSource(fileX);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    private void generateImplClassSource(FileX fileX) throws FileNotFoundException, IOException {
        String string;
        FileX fileX2 = new FileX(fileX, this.implClassname_ + ".java");
        logger.debug((Object)("outputting to " + fileX2.getCanonicalPath()));
        PrintStream printStream = new PrintStream(new FileOutputStream(fileX2));
        printStream.println("package " + this.implPackage_ + ";");
        printStream.println("");
        printStream.println("");
        printStream.println("public class " + this.implClassname_ + " extends net.model3.cfgcfg.Config {");
        printStream.println("");
        printStream.println("    public " + this.implClassname_ + "() {");
        printStream.println("        super(");
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.xml_));
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            printStream.print(string2);
            printStream.print("                " + this.quoteString(string));
            string2 = "+\n";
        }
        bufferedReader.close();
        printStream.println("");
        printStream.println("        );");
        printStream.println("    }");
        for (PropertyMetadata propertyMetadata : this.configMetadata_.getPropertyMetadataList()) {
            String string3 = "prop" + propertyMetadata.getJavaName();
            printStream.println("");
            printStream.println("    private " + propertyMetadata.getObjectTypeJavaName() + " " + string3 + ";");
            printStream.println("    " + propertyMetadata.getReturnTypeJavaName() + " get" + propertyMetadata.getJavaName() + "() {");
            printStream.println("        if ( " + string3 + " == null ) {");
            printStream.println("            " + string3 + " = " + propertyMetadata.getInitializationCode() + ";");
            printStream.println("        }");
            if (propertyMetadata.getReturnType().isPrimitive()) {
                printStream.println("        return " + string3 + "." + propertyMetadata.getReturnType() + "Value();");
            } else {
                printStream.println("        return " + string3 + ";");
            }
            printStream.println("    }");
        }
        printStream.println();
        printStream.println(this.additionalImplSourceCode_);
        printStream.println("}");
        printStream.close();
    }

    private void generateStaticClassSource(FileX fileX) throws FileNotFoundException, IOException {
        FileX fileX2 = new FileX(fileX, this.staticClassname_ + ".java");
        logger.debug((Object)("outputting to " + fileX2.getCanonicalPath()));
        PrintStream printStream = new PrintStream(new FileOutputStream(fileX2));
        printStream.println("package " + this.staticPackage_ + ";");
        printStream.println("");
        printStream.println("");
        printStream.println("import net.model3.file.FileX;");
        printStream.println("");
        printStream.println("public class " + this.staticClassname_ + " {");
        printStream.println("");
        printStream.println("    private static final " + this.implClassname_ + " configImpl_ = new " + this.instantiatedQualClassname_ + "();");
        printStream.println("");
        for (PropertyMetadata propertyMetadata : this.configMetadata_.getPropertyMetadataList()) {
            String string = "prop" + propertyMetadata.getJavaName();
            String string2 = "get" + propertyMetadata.getJavaName();
            printStream.println("");
            printStream.println("    public static " + propertyMetadata.getReturnTypeJavaName() + " " + string2 + "() {");
            printStream.println("        return configImpl_." + string2 + "();");
            printStream.println("    }");
        }
        printStream.println("");
        printStream.println("    public static void initialize( FileX file, String[] commandLineArgs ) {");
        printStream.println("        configImpl_.initialize( file, commandLineArgs );");
        printStream.println("    }");
        printStream.println("}");
        printStream.close();
    }

    private void processProperty(Element element) {
        try {
            String string = element.element("type").getText();
            PropertyMetadata propertyMetadata = PropertyMetadata.instantiate(string);
            Iterator iterator = element.elementIterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                String string2 = element2.getName();
                if (string2.equalsIgnoreCase("type")) continue;
                this.beanTool_.setBeanProperty((Object)propertyMetadata, string2, element2.getText());
            }
            propertyMetadata.loadedFromXml();
            this.configMetadata_.addPropertyMetadata(propertyMetadata);
        }
        catch (Exception exception) {
            logger.error((Object)("error processing the following property element\n" + element.asXML()), (Object)exception);
            throw new RuntimeException("error processing the following property element\n" + element.asXML() + "\n" + exception.getMessage());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        BasicConfigurator.configure();
        ConfigConfig configConfig = new ConfigConfig(new FileX(stringArray[0]));
        configConfig.generateSource(new FileX(stringArray[1]));
    }

    ConfigMetadata getConfigMetadata() {
        return this.configMetadata_;
    }

    public static Map parseValueIntoKeyValuePairs(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tokenizer tokenizer = new Tokenizer(string);
        while (tokenizer.next()) {
            String string2;
            String string3;
            String string4 = tokenizer.currentToken();
            int n = string4.indexOf(61);
            if (n < 0) {
                string3 = string4;
                string2 = "";
            } else {
                string3 = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    String quoteString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }
}

