/*
 * Decompiled with CFR 0.152.
 */
package net.model3.cfgcfg;

import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import net.model3.cfgcfg.ConfigConfig;
import net.model3.cfgcfg.ConfigMetadata;
import net.model3.cfgcfg.PropertyMetadata;
import net.model3.collections.MapX;
import net.model3.collections.PropertiesX;
import net.model3.file.FileX;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class Config {
    private static final Logger logger = LoggerHelper.getLogger();
    private Properties properties_;
    private ConfigMetadata configMetadata_;
    private FileX file_;

    protected Config(String string) {
        ConfigConfig configConfig = new ConfigConfig(string);
        this.configMetadata_ = configConfig.getConfigMetadata();
    }

    public void initialize(FileX fileX, String[] stringArray) {
        logger.info((Object)("loading config file " + fileX.getCanonicalPath() + " for " + this));
        try {
            this.file_ = fileX;
            this.properties_ = new Properties();
            this.properties_.load(new FileInputStream(fileX));
            MapX.makeKeysLowercase((Map)this.properties_);
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                String string = stringArray[i];
                int n = string.indexOf("=");
                if (!string.startsWith("-D") || n <= 0) continue;
                String string2 = string.substring(2, n).toLowerCase();
                String string3 = string.substring(n + 1);
                this.properties_.put(string2, string3);
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
        this.validate();
    }

    private void validate() {
        PropertyMetadata propertyMetadata;
        boolean bl = false;
        Map map = (Map)this.configMetadata_.getPropertyMetadataPropNameMap().clone();
        for (String charSequence2 : this.properties_.keySet()) {
            String string = this.properties_.getProperty(charSequence2);
            propertyMetadata = this.configMetadata_.getPropertyMetadataFromPropName(charSequence2, false);
            if (propertyMetadata == null) {
                logger.error((Object)("no definition found for property  " + charSequence2 + "=" + string + "   in file " + this.file_.getCanonicalPath()));
                bl = true;
            } else {
                try {
                    propertyMetadata.validate(string);
                }
                catch (Exception exception) {
                    logger.error((Object)("unable to parse a " + propertyMetadata.getObjectType().getName() + " from  " + charSequence2 + "=" + string + "   in file " + this.file_.getCanonicalPath()), (Object)exception);
                    bl = true;
                }
            }
            map.remove(charSequence2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.keySet()) {
            propertyMetadata = this.configMetadata_.getPropertyMetadataFromPropName(string);
            if (!propertyMetadata.isRequired()) continue;
            logger.error((Object)("property type " + propertyMetadata.getTypeName() + " name " + propertyMetadata.toString() + " not found in file " + this.file_.getCanonicalPath()));
            stringBuffer.append("\n" + propertyMetadata.getPropertyName() + "=" + propertyMetadata.getTypeName());
            bl = true;
        }
        if (bl) {
            if (stringBuffer.length() > 0) {
                logger.warn((Object)("Required propeties that are missing " + stringBuffer));
            }
            throw new RuntimeException("unable to parse file " + this.file_.getCanonicalPath() + " see previously listed log messages for details.");
        }
    }

    protected Object getPropertyAsObject(String string) {
        return this.getPropertyAsObject(string, null);
    }

    private Object getPropertyAsObject(String string, Class clazz) {
        String string2 = this.properties_.getProperty(string);
        string2 = PropertiesX.processStringForVariables((Properties)System.getProperties(), (String)string2, (boolean)true);
        PropertyMetadata propertyMetadata = this.configMetadata_.getPropertyMetadataFromPropName(string, true);
        if (clazz != null && !clazz.equals(propertyMetadata.getObjectType())) {
            throw new RuntimeException("property " + string + " type desired " + clazz + " does not match type of property " + propertyMetadata.getObjectType());
        }
        try {
            return propertyMetadata.getValue(string2);
        }
        catch (RuntimeException runtimeException) {
            propertyMetadata.getValue(string2);
            throw new RuntimeException(runtimeException.getMessage() + " in " + this.file_.getCanonicalPath());
        }
    }

    public static void main(String[] stringArray) {
    }

    protected ConfigMetadata getConfigMetadata() {
        return this.configMetadata_;
    }

    protected Properties getProperties() {
        return this.properties_;
    }

    protected void setProperties(Properties properties) {
        this.properties_ = properties;
    }
}

