/*
 * Decompiled with CFR 0.152.
 */
package net.model3.apps;

import java.util.HashSet;
import java.util.Set;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.util.Crypto;

public class ValidateChecksums {
    boolean generate;
    boolean fix;
    Directory rootDir;
    Set<String> extensionsToCheck = new HashSet<String>();
    ChecksumCalculator md5Calculator = new ChecksumCalculator(){

        @Override
        String getExtension() {
            return "md5";
        }

        @Override
        byte[] calculate(File file) {
            return file.calculateMd5();
        }
    };
    ChecksumCalculator sha1Calculator = new ChecksumCalculator(){

        @Override
        String getExtension() {
            return "sha1";
        }

        @Override
        byte[] calculate(File file) {
            return file.calculateSha();
        }
    };

    public static void main(String[] stringArray) {
        new ValidateChecksums().run(stringArray);
    }

    void run(String[] stringArray) {
        for (String string : System.getProperty("extensions", "jar,pom,xml").split(",")) {
            this.extensionsToCheck.add(string);
        }
        this.generate = Boolean.parseBoolean(System.getProperty("generate", "false"));
        this.fix = Boolean.parseBoolean(System.getProperty("fix", "false"));
        this.rootDir = stringArray.length == 0 ? new Directory(".") : new Directory(stringArray[0]);
        for (File file : this.rootDir.filesRecursive()) {
            if (!this.extensionsToCheck.contains(file.getExtension()) || this.isChecksum(file)) continue;
            this.md5Calculator.validate(file);
            this.sha1Calculator.validate(file);
        }
    }

    boolean isChecksum(File file) {
        String string = file.getExtension();
        return string.equals("sha1") || string.equals("md5");
    }

    abstract class ChecksumCalculator {
        ChecksumCalculator() {
        }

        abstract String getExtension();

        abstract byte[] calculate(File var1);

        void validate(File file) {
            File file2 = new File(file.getCanonicalPath() + "." + this.getExtension());
            if (file2.exists() || ValidateChecksums.this.generate) {
                String string = Crypto.byteArrayToHexString((byte[])this.calculate(file));
                boolean bl = false;
                if (file2.exists()) {
                    String string2 = file2.readText().split(" ")[0].trim();
                    if (!string.equals(string2)) {
                        System.out.println(this.getExtension() + "  " + string2 + " != " + string + "    " + file.getPathRelativeTo(ValidateChecksums.this.rootDir));
                        bl = ValidateChecksums.this.fix;
                    } else {
                        string2.toCharArray();
                    }
                } else {
                    bl = ValidateChecksums.this.generate;
                }
                if (bl) {
                    file2.write(string);
                }
            }
        }
    }
}

