/*
 * Decompiled with CFR 0.152.
 */
package net.model3.apps;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import net.model3.lang.StringX;

public class SocketListener {
    private static final String NON_ALPHANUMERIC_CHARS = "`~!@#$%^&*()-_=+]}[{;:'\"\\|,<.>/?";
    private static final Map<Character, String> charMap_;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("requires 1 argument port");
            System.exit(1);
        }
        int n = Integer.parseInt(stringArray[0]);
        System.out.println("listening on port " + n);
        ServerSocket serverSocket = new ServerSocket(n);
        Socket socket = serverSocket.accept();
        System.out.println("socket accepted from " + socket.getRemoteSocketAddress());
        System.out.println("socket accepted on " + socket.getLocalSocketAddress());
        byte[] byArray = new byte[1000];
        while (true) {
            int n2 = socket.getInputStream().read(byArray);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(SocketListener.convertToPrintableChars(byArray, n2));
            stringBuilder.append("\r\n");
            stringBuilder.append(StringX.arrayToHexString((byte[])byArray, (int)n2));
            stringBuilder.append("\r\n");
            String string = stringBuilder.toString();
            System.out.print(string);
            socket.getOutputStream().write(string.getBytes());
        }
    }

    static String convertToPrintableChars(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            String string = charMap_.get(Character.valueOf(c));
            if (string == null) {
                string = "\\x" + StringX.byteToHexString((byte)((byte)(c & 0xFF)));
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    static {
        char c;
        charMap_ = new HashMap<Character, String>();
        for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            charMap_.put(Character.valueOf(c), String.valueOf(c));
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            charMap_.put(Character.valueOf(c), String.valueOf(c));
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            charMap_.put(Character.valueOf(c), String.valueOf(c));
        }
        for (char c2 : NON_ALPHANUMERIC_CHARS.toCharArray()) {
            charMap_.put(Character.valueOf(c2), String.valueOf(c2));
        }
        charMap_.put(Character.valueOf('\u0007'), "\\a");
        charMap_.put(Character.valueOf('\b'), "\\b");
        charMap_.put(Character.valueOf('\u007f'), "\\d");
        charMap_.put(Character.valueOf('\f'), "\\f");
        charMap_.put(Character.valueOf('\n'), "\\n");
        charMap_.put(Character.valueOf('\r'), "\\r");
        charMap_.put(Character.valueOf('\t'), "\\t");
        charMap_.put(Character.valueOf('\u000b'), "\\v");
        charMap_.put(Character.valueOf('\u001b'), "\\e");
    }
}

