/*
 * Decompiled with CFR 0.152.
 */
package net.model3.apps;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.model3.bean.ReflectionTool;
import net.model3.collections.ListX;
import net.model3.lang.AbstractComparable;
import net.model3.lang.ByteSize;
import net.model3.lang.TimeDuration;
import net.model3.logging.LogFactory;
import net.model3.logging.LogFactoryNoop;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.util.DateX;

public class FileLister {
    private boolean _recurse = true;
    private Directory _directory = new Directory(".");
    private Integer _count = Integer.MAX_VALUE;
    private TimeDuration _age = new TimeDuration("forever");
    private ByteSize _space = new ByteSize(Long.MAX_VALUE);
    private String _prefix = "";
    private String _suffix = "";

    public static void main(String[] stringArray) {
        try {
            LogFactory.setInstance((LogFactory)new LogFactoryNoop());
            new FileLister(stringArray).run();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.err.println();
            System.err.println("Usage:");
            System.err.println("    -directory xxx");
            System.err.println("    -count ###");
            System.err.println("    -age  (time duration string)");
            System.err.println("    -space (byte size string)");
            System.err.println("    -prefix xxx");
            System.err.println("    -suffix xxx");
            System.err.println("    -recurse true|false|0|1|on|off");
        }
    }

    public FileLister(String[] stringArray) {
        ReflectionTool reflectionTool = new ReflectionTool();
        for (int i = 1; i < stringArray.length; i += 2) {
            String string = stringArray[i - 1];
            if (string.startsWith("-")) {
                string = string.substring(1);
            }
            String string2 = stringArray[i];
            reflectionTool.setBeanProperty((Object)this, string, string2);
        }
    }

    void run() {
        List list = ListX.create();
        for (File file : this._directory.filesRecursive()) {
            String string = file.getName();
            if (!string.startsWith(this._prefix) || !string.endsWith(this._suffix)) continue;
            list.add(file);
        }
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                Long l = file.asFile().lastModified();
                Long l2 = file2.asFile().lastModified();
                return l.compareTo(l2);
            }
        });
        DateX dateX = new DateX();
        long l = this._space.inBytes();
        long l2 = 0L;
        int n = 0;
        for (File file : list) {
            long l3 = l2 + file.length();
            int n2 = n + 1;
            boolean bl = false;
            if (l3 > l) {
                bl = true;
            } else if (n2 > this._count) {
                bl = true;
            } else {
                TimeDuration timeDuration = new TimeDuration(-1L * file.getLastModified().diff().inMilliseconds() + "ms");
                if (timeDuration.greaterThan((AbstractComparable)this._age)) {
                    bl = true;
                }
            }
            if (bl) {
                System.out.println("./" + file.getPathRelativeTo(this._directory));
                continue;
            }
            l2 = l3;
            n = n2;
        }
    }

    public void setRecurse(boolean bl) {
        this._recurse = bl;
    }

    public void setDirectory(Directory directory) {
        this._directory = directory;
    }

    public void setCount(Integer n) {
        this._count = n;
    }

    public void setAge(TimeDuration timeDuration) {
        this._age = timeDuration;
    }

    public void setSpace(ByteSize byteSize) {
        this._space = byteSize;
    }

    public void setPrefix(String string) {
        this._prefix = string;
    }

    public void setSuffix(String string) {
        this._suffix = string;
    }
}

