/*
 * Decompiled with CFR 0.152.
 */
package net.model3.apps;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DirectSendToSmtpServer {
    private String host;
    private int port;
    private String from;
    private Vector to;
    private Vector cc;
    private Hashtable headers;
    private MailPrintStream out;
    private BufferedReader in;
    private Socket socket;

    public DirectSendToSmtpServer() {
        this("localhost");
    }

    public DirectSendToSmtpServer(String string, int n) {
        try {
            this.host = string;
            this.port = n;
            this.to = new Vector();
            this.cc = new Vector();
            this.headers = new Hashtable();
            this.setHeader("X-Mailer", "net.model3.net.MailMessage");
            this.connect();
            this.sendHelo();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public DirectSendToSmtpServer(String string) {
        this.host = string;
        this.port = 25;
        this.to = new Vector();
        this.cc = new Vector();
        this.headers = new Hashtable();
        this.setHeader("X-Mailer", "net.model3.net.MailMessage");
        this.connect();
        this.sendHelo();
    }

    public void from(String string) {
        this.sendFrom(string);
        this.from = string;
    }

    public void to(String string) {
        this.sendRcpt(string);
        this.to.addElement(string);
    }

    public void cc(String string) {
        this.sendRcpt(string);
        this.cc.addElement(string);
    }

    public void bcc(String string) {
        this.sendRcpt(string);
    }

    public void setSubject(String string) {
        this.headers.put("Subject", string);
    }

    public void setHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public PrintStream getPrintStream() {
        this.setFromHeader();
        this.setToHeader();
        this.setCcHeader();
        this.sendData();
        this.flushHeaders();
        return this.out;
    }

    void setFromHeader() {
        this.setHeader("From", this.from);
    }

    void setToHeader() {
        this.setHeader("To", this.vectorToList(this.to));
    }

    void setCcHeader() {
        this.setHeader("Cc", this.vectorToList(this.cc));
    }

    String vectorToList(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    void flushHeaders() {
        Enumeration enumeration = this.headers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.headers.get(string);
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(": ").append(string2))));
        }
        this.out.println();
        this.out.flush();
    }

    public void sendAndClose() {
        this.sendDot();
        this.disconnect();
    }

    static String sanitizeAddress(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            char c = string.charAt(i);
            if (c == '(') {
                ++n;
                if (n2 != 0) continue;
                n3 = i;
                continue;
            }
            if (c == ')') {
                --n;
                if (n3 != 0) continue;
                n2 = i + 1;
                continue;
            }
            if (n == 0 && c == '<') {
                n2 = i + 1;
                continue;
            }
            if (n != 0 || c != '>') continue;
            n3 = i;
        }
        if (n3 == 0) {
            n3 = n4;
        }
        return string.substring(n2, n3);
    }

    void connect() {
        try {
            this.socket = new Socket(this.host, this.port);
            this.out = new MailPrintStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.getReady();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    void getReady() {
        try {
            String string = this.in.readLine();
            int[] nArray = new int[]{220};
            if (!this.isResponseOK(string, nArray)) {
                throw new RuntimeException("Didn't get introduction from server: ".concat(String.valueOf(String.valueOf(string))));
            }
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    void sendHelo() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            int[] nArray = new int[]{250};
            this.send("HELO ".concat(String.valueOf(String.valueOf(string))), nArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    void sendFrom(String string) {
        try {
            int[] nArray = new int[]{250};
            this.send(String.valueOf(String.valueOf(new StringBuffer("MAIL FROM: <").append(DirectSendToSmtpServer.sanitizeAddress(string)).append(">"))), nArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    void sendRcpt(String string) {
        int[] nArray = new int[]{250, 251};
        this.send(String.valueOf(String.valueOf(new StringBuffer("RCPT TO: <").append(DirectSendToSmtpServer.sanitizeAddress(string)).append(">"))), nArray);
    }

    void sendData() {
        int[] nArray = new int[]{354};
        this.send("DATA", nArray);
    }

    void sendDot() {
        int[] nArray = new int[]{250};
        this.send("\r\n.", nArray);
    }

    void sendQuit() {
        int[] nArray = new int[]{221};
        this.send("QUIT", nArray);
    }

    void send(String string, int[] nArray) {
        this.out.rawPrint(string + "\r\n");
        try {
            String string2 = this.in.readLine();
            if (!this.isResponseOK(string2, nArray)) {
                throw new RuntimeException("Unexpected reply to command: " + string + ": " + string2);
            }
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    boolean isResponseOK(String string, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (!string.startsWith("".concat(String.valueOf(String.valueOf(nArray[i]))))) continue;
            return true;
        }
        return false;
    }

    void disconnect() {
        try {
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    class MailPrintStream
    extends PrintStream {
        int lastChar;

        public MailPrintStream(OutputStream outputStream) {
            super(outputStream, true);
        }

        @Override
        public void write(int n) {
            if (n == 10 && this.lastChar != 13) {
                this.rawWrite(13);
                this.rawWrite(n);
            } else if (n == 46 && this.lastChar == 10) {
                this.rawWrite(46);
                this.rawWrite(n);
            } else if (n != 10 && this.lastChar == 13) {
                this.rawWrite(10);
                this.rawWrite(n);
                if (n == 46) {
                    this.rawWrite(46);
                }
            } else {
                this.rawWrite(n);
            }
            this.lastChar = n;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                this.write(byArray[n + i]);
            }
        }

        void rawWrite(int n) {
            super.write(n);
        }

        void rawPrint(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                this.rawWrite(string.charAt(i));
            }
        }
    }
}

