/*
 * Decompiled with CFR 0.152.
 */
package css.triggers;

import css.component.ComponentWrapper;
import css.selectors.AbstractSelector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JComponent;
import net.model3.collections.SetX;

public class PropertyChangeTrigger
extends AbstractSelector {
    Set<String> _properties = SetX.create();
    PropertyChangeListener _propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (PropertyChangeTrigger.this._properties.contains(propertyChangeEvent.getPropertyName())) {
                JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
                ComponentWrapper componentWrapper = ComponentWrapper.get(jComponent);
                componentWrapper.reapplyStyles();
            }
        }
    };

    public PropertyChangeTrigger(String ... stringArray) {
        for (String string : stringArray) {
            this.addProperty(string);
        }
    }

    @Override
    public boolean select(JComponent jComponent) {
        return true;
    }

    public void addProperty(String string) {
        this._properties.add(string);
    }

    public void setProperties(Set<String> set) {
        this._properties = set;
    }

    @Override
    public void attach(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this._propertyChangeListener);
        jComponent.addPropertyChangeListener(this._propertyChangeListener);
    }

    @Override
    public void detach(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this._propertyChangeListener);
    }

    @Override
    public boolean isStaticOnly() {
        return false;
    }
}

