/*
 * Decompiled with CFR 0.152.
 */
package css.triggers;

import css.component.ComponentWrapper;
import css.selectors.AbstractSelector;
import css.triggers.TriggerComponentDelegate;
import javax.swing.JComponent;
import net.model3.lang.ClassX;

public abstract class AbstractTrigger<T extends TriggerComponentDelegate>
extends AbstractSelector {
    boolean _stateNeededToActivate;

    public AbstractTrigger(ActivationCondition activationCondition) {
        this._stateNeededToActivate = activationCondition == ActivationCondition.ActivateOnTrue;
    }

    @Override
    public boolean select(JComponent jComponent) {
        return this.getDelegateForComponent(jComponent).getState() == this._stateNeededToActivate;
    }

    public T getDelegateForComponent(JComponent jComponent) {
        ComponentWrapperAttributeKey componentWrapperAttributeKey;
        ComponentWrapper componentWrapper = ComponentWrapper.get(jComponent);
        TriggerComponentDelegate triggerComponentDelegate = (TriggerComponentDelegate)componentWrapper.getAttribute(componentWrapperAttributeKey = new ComponentWrapperAttributeKey(jComponent));
        if (triggerComponentDelegate == null) {
            triggerComponentDelegate = this.createDelegate(jComponent);
            triggerComponentDelegate.setWrapper(componentWrapper);
            componentWrapper.setAttribute(componentWrapperAttributeKey, triggerComponentDelegate);
        }
        return (T)triggerComponentDelegate;
    }

    public T createDelegate(JComponent jComponent) {
        Class clazz = ClassX.getParameterizedType(this.getClass());
        return (T)((TriggerComponentDelegate)ClassX.newInstance((Class)clazz));
    }

    @Override
    public boolean isStaticOnly() {
        return false;
    }

    public static enum ActivationCondition {
        ActivateOnTrue,
        ActivateOnFalse;

    }

    class ComponentWrapperAttributeKey {
        JComponent _component;

        private ComponentWrapperAttributeKey(JComponent jComponent) {
            this._component = jComponent;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this._component == null ? 0 : this._component.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ComponentWrapperAttributeKey componentWrapperAttributeKey = (ComponentWrapperAttributeKey)object;
            if (!this.getOuterType().equals(componentWrapperAttributeKey.getOuterType())) {
                return false;
            }
            return !(this._component == null ? componentWrapperAttributeKey._component != null : !this._component.equals(componentWrapperAttributeKey._component));
        }

        private AbstractTrigger<T> getOuterType() {
            return AbstractTrigger.this;
        }
    }
}

