/*
 * Decompiled with CFR 0.152.
 */
package css.loader;

import css.Selector;
import css.animate.AnimationDefinition;
import css.impl.StyleImpl;
import css.impl.StylesheetImpl;
import css.loader.ClosureParameters;
import css.loader.StyleParameters;
import css.loader.ValueToStylePropertyBinder;
import css.selectors.ChildSelector;
import css.selectors.ComponentNameSelector;
import css.selectors.JavaClassSelector;
import css.selectors.StyleClassSelector;
import css.selectors.TrueSelector;
import css.triggers.AbstractTrigger;
import css.triggers.FocusTrigger;
import css.triggers.MouseButtonTrigger;
import css.triggers.MouseOverTrigger;
import css.triggers.PropertyChangeTrigger;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.newfile.File;

public class StylesheetParser
extends GroovyObjectSupport {
    final Logger logger = LoggerHelper.getLogger();
    StyleImpl _currentStyle;
    StylesheetImpl _stylesheetBeingLoaded;
    LoaderBinding _binding = new LoaderBinding();
    boolean _logAccess = false;

    public static void main(String[] stringArray) throws Exception {
        StylesheetImpl stylesheetImpl = new StylesheetParser().parse(new File("./src/test/resources/stylesheet.groovy"));
        stylesheetImpl.toString();
    }

    public StylesheetParser() {
        this._binding.setVariable("s", new Closure((Object)this){

            public Object doCall(Object[] objectArray) {
                StyleParameters styleParameters = new StyleParameters(objectArray);
                StylesheetParser.this.runStyleValuesClosure(styleParameters.getClosure(), styleParameters.createPositionalSelector(), styleParameters.createNamedParmsSelector(), false);
                return null;
            }
        });
        this._binding.copyVariable("s", "select");
        this._binding.setVariable("ch", new Closure((Object)this){

            public Object doCall(Object[] objectArray) {
                StyleParameters styleParameters = new StyleParameters(objectArray);
                StylesheetParser.this.runStyleValuesClosure(styleParameters.getClosure(), styleParameters.createPositionalSelector(), styleParameters.createNamedParmsSelector(), true);
                return null;
            }
        });
        this._binding.copyVariable("ch", "child");
        this._binding.setVariable("a", new Closure((Object)this){

            public Object doCall(Object[] objectArray) {
                StyleParameters styleParameters = new StyleParameters(objectArray);
                if (styleParameters.getClosure() == null) {
                    StylesheetParser.this._currentStyle.addAttach(styleParameters.createPositionalSelector());
                } else {
                    StylesheetParser.this.runStyleValuesClosure(styleParameters.getClosure(), TrueSelector.get(), styleParameters.createPositionalSelector(), false);
                }
                return null;
            }
        });
        this._binding.copyVariable("a", "activate");
        this._binding.setVariable("anim", new Closure((Object)this){

            public Object doCall(Object[] objectArray) {
                ClosureParameters closureParameters = new ClosureParameters(objectArray);
                AnimationDefinition animationDefinition = new AnimationDefinition();
                animationDefinition.setTargetValue(closureParameters.getPositional().get(0));
                if (closureParameters.getNamed().containsKey("over")) {
                    animationDefinition.setOver((String)closureParameters.getNamed().get("over"));
                }
                return animationDefinition;
            }
        });
        this._binding.copyVariable("anim", "animate");
        this._binding.setVariable("bind", new Closure((Object)this){

            public Object doCall(Object[] objectArray) {
                ClosureParameters closureParameters = new ClosureParameters(objectArray);
                PropertyChangeTrigger propertyChangeTrigger = new PropertyChangeTrigger(new String[0]);
                for (Object object : closureParameters.getPositional()) {
                    propertyChangeTrigger.addProperty(object.toString());
                }
                return propertyChangeTrigger;
            }
        });
        this._binding.copyVariable("anim", "animate");
        this._binding.setVariable("styleClass", new Closure((Object)this){

            public Object doCall(String string) {
                return new StyleClassSelector(string);
            }
        });
        this._binding.setVariable("javaClass", new Closure((Object)this){

            public Object doCall(Class<?> clazz) {
                return new JavaClassSelector(clazz);
            }
        });
        this._binding.setVariable("childOf", new Closure((Object)this){

            public Object doCall(Selector selector) {
                return new ChildSelector(selector, false);
            }
        });
        this._binding.setVariable("directDescendantOf", new Closure((Object)this){

            public Object doCall(Selector selector) {
                return new ChildSelector(selector, true);
            }
        });
        this._binding.setVariable("name", new Closure((Object)this){

            public Object doCall(String string) {
                return new ComponentNameSelector(string);
            }
        });
        this._binding.setVariable("mouseOver", new Closure((Object)this){

            public Object doCall() {
                return new MouseOverTrigger(AbstractTrigger.ActivationCondition.ActivateOnTrue);
            }
        });
        this._binding.setVariable("mouseOut", new Closure((Object)this){

            public Object doCall() {
                return new MouseOverTrigger(AbstractTrigger.ActivationCondition.ActivateOnFalse);
            }
        });
        this._binding.setVariable("mouseDown", new Closure((Object)this){

            public Object doCall() {
                return new MouseButtonTrigger(AbstractTrigger.ActivationCondition.ActivateOnTrue);
            }
        });
        this._binding.setVariable("mouseUp", new Closure((Object)this){

            public Object doCall() {
                return new MouseButtonTrigger(AbstractTrigger.ActivationCondition.ActivateOnFalse);
            }
        });
        this._binding.setVariable("onFocus", new Closure((Object)this){

            public Object doCall() {
                return new FocusTrigger(AbstractTrigger.ActivationCondition.ActivateOnTrue);
            }
        });
        this._binding.setVariable("onBlur", new Closure((Object)this){

            public Object doCall() {
                return new FocusTrigger(AbstractTrigger.ActivationCondition.ActivateOnFalse);
            }
        });
        this._logAccess = true;
    }

    void runStyleValuesClosure(Closure closure, Selector selector, Selector selector2, boolean bl) {
        StyleImpl styleImpl = this._currentStyle;
        this._currentStyle = styleImpl == null ? this._stylesheetBeingLoaded.createStyle() : (bl ? styleImpl.createDescendantStyle() : styleImpl.createSubStyle());
        this._currentStyle.setAttach(selector);
        this._currentStyle.setActivate(selector2);
        closure.setDelegate((Object)this._currentStyle);
        closure.run();
        this._currentStyle = styleImpl;
    }

    public Object invokeMethod(String string, Object object) {
        if (this._logAccess) {
            this.logger.debug((Object)("invokeMethod(\"" + string + "\"," + object + ")"));
        }
        return super.invokeMethod(string, object);
    }

    public void setProperty(String string, Object object) {
        if (this._logAccess) {
            this.logger.debug((Object)("setProperty(\"" + string + "\"," + object + ")"));
        }
        super.setProperty(string, object);
    }

    public StylesheetImpl parse(File file) {
        try {
            this._stylesheetBeingLoaded = new StylesheetImpl();
            GroovyShell groovyShell = new GroovyShell((Binding)this._binding);
            Script script = groovyShell.parse(file.asFile());
            script.run();
            return this._stylesheetBeingLoaded;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public StylesheetImpl parse(UrlX urlX) {
        this._stylesheetBeingLoaded = new StylesheetImpl();
        GroovyShell groovyShell = new GroovyShell((Binding)this._binding);
        Script script = groovyShell.parse((InputStream)new ByteArrayInputStream(urlX.getContentAsBytes()));
        script.run();
        return this._stylesheetBeingLoaded;
    }

    class LoaderBinding
    extends Binding {
        private final Logger logger = LoggerHelper.getLogger();

        LoaderBinding() {
        }

        public Object getProperty(String string) {
            if (StylesheetParser.this._logAccess) {
                this.logger.trace((Object)("getProperty(\"" + string + "\")"));
            }
            return super.getProperty(string);
        }

        public Object getVariable(String string) {
            if (StylesheetParser.this._logAccess) {
                this.logger.trace((Object)("getVariable(\"" + string + "\")"));
            }
            return super.getVariable(string);
        }

        public void setVariable(String string, Object object) {
            if (StylesheetParser.this._logAccess) {
                this.logger.trace((Object)("setVariable(\"" + string + "\"," + object + ")"));
            }
            if (StylesheetParser.this._currentStyle != null) {
                if (object instanceof ValueToStylePropertyBinder) {
                    object = ((ValueToStylePropertyBinder)object).resolveToStyleProperty(StylesheetParser.this._currentStyle, string);
                }
                StylesheetParser.this._currentStyle.getValues().put(string, object);
            } else {
                super.setVariable(string, object);
            }
        }

        public void setProperty(String string, Object object) {
            if (StylesheetParser.this._logAccess) {
                this.logger.trace((Object)("setProperty(\"" + string + "\"," + object + ")"));
            }
            super.setProperty(string, object);
        }

        void copyVariable(String string, String string2) {
            this.setVariable(string2, this.getVariable(string));
        }
    }
}

