/*
 * Decompiled with CFR 0.152.
 */
package css.impl;

import css.Style;
import css.Stylesheet;
import css.impl.StyleImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.lang.Visitor;
import net.model3.swing.GuiHelper;

public class StylesheetImpl
implements Stylesheet {
    List<Style> _styles = new ArrayList<Style>();
    StylesheetContainerListener _containerListener = new StylesheetContainerListener();
    Map<JComponent, Void> _applicationPoints = new WeakHashMap<JComponent, Void>();

    public void addStyle(StyleImpl styleImpl) {
        this._styles.add(styleImpl);
        styleImpl.setStylesheet(this);
    }

    @Override
    public void applyTo(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty(Stylesheet.class, this);
            this._applicationPoints.put(jComponent, null);
            this.attach(jComponent);
        }
    }

    private void attach(JComponent jComponent) {
        this.attachSingleComponent(jComponent);
        this.visitDirectDescendants(jComponent, new Visitor<JComponent>(){

            public void visit(JComponent jComponent) {
                if (jComponent instanceof JComponent) {
                    StylesheetImpl.this.attach(jComponent);
                }
            }
        });
    }

    private void detach(JComponent jComponent) {
        this.detachSingleComponent(jComponent);
        this.visitDirectDescendants(jComponent, new Visitor<JComponent>(){

            public void visit(JComponent jComponent) {
                if (jComponent instanceof JComponent) {
                    StylesheetImpl.this.detach(jComponent);
                }
            }
        });
    }

    private void detachSingleComponent(JComponent jComponent) {
        if (jComponent instanceof Container) {
            jComponent.removeContainerListener(this._containerListener);
        }
        for (Style style : this._styles) {
            style.detach(jComponent);
        }
    }

    private void attachSingleComponent(JComponent jComponent) {
        if (jComponent instanceof Container) {
            jComponent.removeContainerListener(this._containerListener);
            jComponent.addContainerListener(this._containerListener);
        }
        for (Style style : this._styles) {
            style.attach(jComponent);
        }
    }

    @Override
    public List<Style> getStyles() {
        return ListX.create(this._styles);
    }

    public void resetStyles(List<Style> list) {
        for (Style object : this._styles) {
            object.detachAll();
        }
        this._styles = list;
        for (JComponent jComponent : this._applicationPoints.keySet()) {
            this.attach(jComponent);
        }
    }

    @Override
    public Set<JComponent> getApplicationPoints() {
        return SetX.create(this._applicationPoints.keySet());
    }

    void visitDirectDescendants(JComponent jComponent, Visitor<JComponent> visitor) {
        GuiHelper.visitDirectDescendantsOnly((Component)jComponent, visitor);
    }

    public StyleImpl createStyle() {
        StyleImpl styleImpl = new StyleImpl();
        this._styles.add(styleImpl);
        return styleImpl;
    }

    class StylesheetContainerListener
    implements ContainerListener {
        StylesheetContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JComponent) {
                StylesheetImpl.this.attach((JComponent)containerEvent.getChild());
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JComponent) {
                StylesheetImpl.this.detach((JComponent)containerEvent.getChild());
            }
        }
    }
}

